package com.ekoapp.ekosdk.internal.api.mapper

import com.ekoapp.ekosdk.internal.api.dto.EkoUserDto
import com.ekoapp.ekosdk.internal.data.UserDatabase
import com.ekoapp.ekosdk.internal.data.model.EkoUserFlag

object EkoUserListPersister : EkoObjectPersister() {
	@JvmStatic
    fun persist(userDtoList: List<EkoUserDto>) {
		val userDatabase = UserDatabase.get()
		userDatabase.runInTransaction {
			persistChanges(userDtoList, EkoUserMapper.MAPPER, userDatabase.userDao())
			val flagDao = userDatabase.userFlagDao()
			for (userDto in userDtoList) {
				val userFlag = EkoUserFlag(userDto.userId)
				userFlag.flag = userDto.flag
				val diskFlag = flagDao.getByIdNow(userDto.userId)
				if (diskFlag != null) {
					userFlag.localFlag = diskFlag.localFlag
					flagDao.update(userFlag)
				} else {
					flagDao.insert(userFlag)
				}
			}
		}
	}
}