package com.amity.socialcloud.sdk.core.domain.reaction

import com.amity.socialcloud.sdk.core.domain.ComposerUseCase
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase
import com.amity.socialcloud.sdk.model.core.reaction.AmityReaction

internal class ReactionComposerUseCase : ComposerUseCase() {

    fun execute(reaction: AmityReaction): AmityReaction {
        addUser(reaction)
        return reaction
    }

    private fun addUser(reaction: AmityReaction) {
        reaction.user = UserGetUseCase().execute(reaction.getCreatorId())
    }
}