package com.amity.socialcloud.sdk.api.chat.presence

import com.amity.socialcloud.sdk.core.CoreClient
import com.amity.socialcloud.sdk.model.core.presence.AmityChannelPresence
import io.reactivex.rxjava3.core.Flowable

class AmityChannelPresenceRepository internal constructor() {

    private val presenceSyncEngine
        get() = CoreClient.presenceSyncEngine

    /* begin_public_function
     id: channel.presence.sync_channel_presence
   */
    fun syncChannelPresence(channelId: String, viewId: String = "amity-global") {
        presenceSyncEngine?.syncChannelPresence(channelId, viewId)
    }
    /* end_public_function */

    /* begin_public_function
     id: channel.presence.unsync_channel_presence
   */
    fun unsyncChannelPresence(channelId: String, viewId: String = "amity-global") {
        presenceSyncEngine?.unsyncChannelPresence(channelId, viewId)
    }
    /* end_public_function */

    /* begin_public_function
     id: channel.presence.unsync_all_channel_presence
   */
    fun unsyncAllChannelPresence() {
        presenceSyncEngine?.unsyncAllChannelPresence()
    }
    /* end_public_function */

    /* begin_public_function
     id: channel.presence.get_syncing_channel_presence
   */
    fun getSyncingChannelPresence(): Flowable<List<AmityChannelPresence>> {
        return presenceSyncEngine?.getSyncingChannelPresence() ?: Flowable.empty()
    }
    /* end_public_function */
}