package com.ekoapp.ekosdk.internal.usecase.file

import com.amity.socialcloud.sdk.core.data.file.FileRepository
import com.amity.socialcloud.sdk.model.core.file.AmityClip
import com.amity.socialcloud.sdk.model.core.file.AmityVideo
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

internal class GetClipUrlUseCase {

    fun execute(fileJson: JsonObject?, quality: AmityVideo.Quality? = null): Single<AmityClip> {
        return parseFileId(fileJson, quality ?: AmityVideo.Quality.ORIGINAL)
            .flatMap { clipId -> FileRepository().getClip(clipId)?.let { Single.just(it) } ?: Single.never() }
    }

    private fun parseFileId(fileJson: JsonObject?, quality: AmityVideo.Quality): Single<String> {
        return Single.fromCallable {
            val fileId =
                fileJson?.get(CLIP_FILE_ID_KEY)?.asJsonObject?.get(quality.apiString)?.asString
            if (fileId != null) {
                return@fromCallable fileId
            } else {
                throw Exception("CLip is unavailable")
            }
        }
    }
}

private const val CLIP_FILE_ID_KEY = "clipFileId"

