package com.amity.socialcloud.sdk.core.data.presence

import com.ekoapp.ekosdk.internal.api.AmityHttpClient
import com.ekoapp.ekosdk.internal.api.dto.PresenceSettingDto
import com.ekoapp.ekosdk.internal.api.dto.PresenceUserSettingDto
import com.ekoapp.ekosdk.internal.api.dto.UserPresenceListDto
import com.ekoapp.ekosdk.internal.api.socket.request.PresenceUserSettingUpdateRequest
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

internal class PresenceRemoteDataStore {

    fun getPresenceSetting(): Single<PresenceSettingDto> {
        return AmityHttpClient.get(PresenceApi::class).flatMap {
            it.getPresenceSetting()
        }
    }

    fun updatePresenceUserSetting(enable: Boolean): Single<PresenceUserSettingDto> {
        val request = PresenceUserSettingUpdateRequest(
            enabled = enable
        )
        return AmityHttpClient.get(PresenceApi::class).flatMap {
            it.updatePresenceUserSetting(request)
        }
    }

    fun sendPresenceHeartbeat(): Single<JsonObject> {
        return AmityHttpClient.get(PresenceApi::class).flatMap {
            it.sendPresenceHeartbeat()
        }
    }

    fun getUserPresence(userIds: List<String>): Single<UserPresenceListDto> {
        return AmityHttpClient.get(PresenceApi::class).flatMap {
            it.getUserPresence(userIds)
        }
    }

    fun getOnlineUsers(): Single<UserPresenceListDto> {
        return AmityHttpClient.get(PresenceApi::class).flatMap {
            it.getOnlineUsers()
        }
    }

    fun getOnlineUsersCount(): Single<JsonObject> {
        return AmityHttpClient.get(PresenceApi::class).flatMap {
            it.getOnlineUsersCount()
        }
    }
}