package com.amity.socialcloud.sdk.social.domain.story.query

import com.amity.socialcloud.sdk.api.social.story.AmityStorySortOption
import com.amity.socialcloud.sdk.model.social.story.AmityStory
import com.amity.socialcloud.sdk.social.data.story.StoryRepository
import com.amity.socialcloud.sdk.social.domain.story.StoryComposerUseCase
import io.reactivex.rxjava3.core.Flowable


internal class GetStoriesByTargetsUseCase {

    fun execute(
        targets: List<Pair<AmityStory.TargetType, String>>,
        sortOption: AmityStorySortOption
    ): Flowable<List<AmityStory>> {
        return StoryRepository().getStoriesByTargets(targets = targets, orderBy = sortOption)
            .map {
                it.map {
                    StoryComposerUseCase().execute(it)
                }
            }
    }

}