package com.amity.socialcloud.sdk.api.core.encryption

sealed class AmityDBEncryption(val authDBKey: ByteArray?, val userDBKey: ByteArray?) {

    object NONE : AmityDBEncryption(authDBKey = null, userDBKey = null)

    class AUTH(encryptionKey: ByteArray) : AmityDBEncryption(authDBKey = encryptionKey, userDBKey = null)

    class ALL(encryptionKey: ByteArray) : AmityDBEncryption(authDBKey = encryptionKey, userDBKey = encryptionKey)

}
