package com.amity.socialcloud.sdk.model.social.community

enum class AmityJoinRequestStatus(val status: String) {  // Add 'val' here
    PENDING("pending"),
    APPROVED("approved"),
    REJECTED("rejected"),
    CANCELLED("cancelled");

    companion object {
        fun fromApiKey(apiKey: String): AmityJoinRequestStatus = when (apiKey.lowercase()) {
            "pending" -> PENDING
            "approved" -> APPROVED
            "rejected" -> REJECTED
            "cancelled" -> CANCELLED
            else -> throw IllegalArgumentException("Unknown status: $apiKey")
        }
    }
}