/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ekoapp.ekosdk.internal.SocialSettingsEntity;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.SocialSettingsDao;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class SocialSettingsDao_Impl
extends SocialSettingsDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<SocialSettingsEntity> __insertionAdapterOfSocialSettingsEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<SocialSettingsEntity> __deletionAdapterOfSocialSettingsEntity;
    private final EntityDeletionOrUpdateAdapter<SocialSettingsEntity> __updateAdapterOfSocialSettingsEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public SocialSettingsDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfSocialSettingsEntity = new EntityInsertionAdapter<SocialSettingsEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `social_settings` (`settingId`,`enabled`,`allowAllUserToCreateStory`,`membershipAcceptance`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, SocialSettingsEntity value) {
                if (value.getSettingId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getSettingId());
                }
                int _tmp = value.getEnabled() ? 1 : 0;
                stmt.bindLong(2, (long)_tmp);
                int _tmp_1 = value.getAllowAllUserToCreateStory() ? 1 : 0;
                stmt.bindLong(3, (long)_tmp_1);
                if (value.getMembershipAcceptance() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getMembershipAcceptance());
                }
                String _tmp_2 = SocialSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_2);
                }
                String _tmp_3 = SocialSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_3);
                }
                String _tmp_4 = SocialSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_4);
                }
            }
        };
        this.__deletionAdapterOfSocialSettingsEntity = new EntityDeletionOrUpdateAdapter<SocialSettingsEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `social_settings` WHERE `settingId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, SocialSettingsEntity value) {
                if (value.getSettingId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getSettingId());
                }
            }
        };
        this.__updateAdapterOfSocialSettingsEntity = new EntityDeletionOrUpdateAdapter<SocialSettingsEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `social_settings` SET `settingId` = ?,`enabled` = ?,`allowAllUserToCreateStory` = ?,`membershipAcceptance` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `settingId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, SocialSettingsEntity value) {
                if (value.getSettingId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getSettingId());
                }
                int _tmp = value.getEnabled() ? 1 : 0;
                stmt.bindLong(2, (long)_tmp);
                int _tmp_1 = value.getAllowAllUserToCreateStory() ? 1 : 0;
                stmt.bindLong(3, (long)_tmp_1);
                if (value.getMembershipAcceptance() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getMembershipAcceptance());
                }
                String _tmp_2 = SocialSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_2);
                }
                String _tmp_3 = SocialSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_3);
                }
                String _tmp_4 = SocialSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_4);
                }
                if (value.getSettingId() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getSettingId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from social_settings";
                return "DELETE from social_settings";
            }
        };
    }

    @Override
    public void insertImpl(SocialSettingsEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfSocialSettingsEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends SocialSettingsEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfSocialSettingsEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(SocialSettingsEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfSocialSettingsEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends SocialSettingsEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfSocialSettingsEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(SocialSettingsEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfSocialSettingsEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(SocialSettingsEntity object) {
        this.__db.beginTransaction();
        try {
            SocialSettingsDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends SocialSettingsEntity> objects) {
        this.__db.beginTransaction();
        try {
            SocialSettingsDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(SocialSettingsEntity object) {
        this.__db.beginTransaction();
        try {
            SocialSettingsDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    @Override
    public Flowable<SocialSettingsEntity> getSocialSettings(String settingId) {
        String _sql = "select * from social_settings where settingId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from social_settings where settingId = ?", (int)1);
        int _argIndex = 1;
        if (settingId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, settingId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"social_settings"}, (Callable)new Callable<SocialSettingsEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SocialSettingsEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)SocialSettingsDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    SocialSettingsEntity _result;
                    int _cursorIndexOfSettingId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"settingId");
                    int _cursorIndexOfEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"enabled");
                    int _cursorIndexOfAllowAllUserToCreateStory = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"allowAllUserToCreateStory");
                    int _cursorIndexOfMembershipAcceptance = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"membershipAcceptance");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new SocialSettingsEntity();
                        String _tmpSettingId = _cursor.isNull(_cursorIndexOfSettingId) ? null : _cursor.getString(_cursorIndexOfSettingId);
                        _result.setSettingId(_tmpSettingId);
                        int _tmp = _cursor.getInt(_cursorIndexOfEnabled);
                        boolean _tmpEnabled = _tmp != 0;
                        _result.setEnabled(_tmpEnabled);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfAllowAllUserToCreateStory);
                        boolean _tmpAllowAllUserToCreateStory = _tmp_1 != 0;
                        _result.setAllowAllUserToCreateStory(_tmpAllowAllUserToCreateStory);
                        String _tmpMembershipAcceptance = _cursor.isNull(_cursorIndexOfMembershipAcceptance) ? null : _cursor.getString(_cursorIndexOfMembershipAcceptance);
                        _result.setMembershipAcceptance(_tmpMembershipAcceptance);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = SocialSettingsDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = SocialSettingsDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = SocialSettingsDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    SocialSettingsEntity socialSettingsEntity = _result;
                    return socialSettingsEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

