/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.user;

import android.database.Cursor;
import androidx.paging.PagingSource;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.core.data.user.UserDao;
import com.amity.socialcloud.sdk.entity.core.user.UserEntity;
import com.amity.socialcloud.sdk.model.core.permission.AmityPermissions;
import com.amity.socialcloud.sdk.model.core.role.AmityRoles;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoPermissionsTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoRolesTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class UserDao_Impl
extends UserDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<UserEntity> __insertionAdapterOfUserEntity;
    private final EkoRolesTypeConverter __ekoRolesTypeConverter = new EkoRolesTypeConverter();
    private final EkoPermissionsTypeConverter __ekoPermissionsTypeConverter = new EkoPermissionsTypeConverter();
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<UserEntity> __deletionAdapterOfUserEntity;
    private final EntityDeletionOrUpdateAdapter<UserEntity> __updateAdapterOfUserEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteById;

    public UserDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfUserEntity = new EntityInsertionAdapter<UserEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `user` (`userId`,`mid`,`path`,`displayName`,`roles`,`permissions`,`flagCount`,`metadata`,`avatarFileId`,`avatarCustomUrl`,`description`,`isGlobalBan`,`isDeleted`,`isBrand`,`lastHeartbeat`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, UserEntity value) {
                if (value.getUserId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUserId());
                }
                if (value.getMid() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getMid());
                }
                if (value.getPath() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getPath());
                }
                if (value.getDisplayName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getDisplayName());
                }
                String _tmp = UserDao_Impl.this.__ekoRolesTypeConverter.ekoRolesToString(value.getRoles());
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp);
                }
                String _tmp_1 = UserDao_Impl.this.__ekoPermissionsTypeConverter.ekoPermissionsToString(value.getPermissions());
                if (_tmp_1 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_1);
                }
                stmt.bindLong(7, (long)value.getFlagCount());
                String _tmp_2 = UserDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp_2 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_2);
                }
                if (value.getAvatarFileId() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getAvatarFileId());
                }
                if (value.getAvatarCustomUrl() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getAvatarCustomUrl());
                }
                if (value.getDescription() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getDescription());
                }
                int _tmp_3 = value.isGlobalBan() ? 1 : 0;
                stmt.bindLong(12, (long)_tmp_3);
                int _tmp_4 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(13, (long)_tmp_4);
                int _tmp_5 = value.isBrand() ? 1 : 0;
                stmt.bindLong(14, (long)_tmp_5);
                String _tmp_6 = UserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLastHeartbeat());
                if (_tmp_6 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, _tmp_6);
                }
                String _tmp_7 = UserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, _tmp_7);
                }
                String _tmp_8 = UserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_8 == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, _tmp_8);
                }
                String _tmp_9 = UserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_9 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_9);
                }
            }
        };
        this.__deletionAdapterOfUserEntity = new EntityDeletionOrUpdateAdapter<UserEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `user` WHERE `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, UserEntity value) {
                if (value.getUserId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUserId());
                }
            }
        };
        this.__updateAdapterOfUserEntity = new EntityDeletionOrUpdateAdapter<UserEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `user` SET `userId` = ?,`mid` = ?,`path` = ?,`displayName` = ?,`roles` = ?,`permissions` = ?,`flagCount` = ?,`metadata` = ?,`avatarFileId` = ?,`avatarCustomUrl` = ?,`description` = ?,`isGlobalBan` = ?,`isDeleted` = ?,`isBrand` = ?,`lastHeartbeat` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, UserEntity value) {
                if (value.getUserId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUserId());
                }
                if (value.getMid() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getMid());
                }
                if (value.getPath() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getPath());
                }
                if (value.getDisplayName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getDisplayName());
                }
                String _tmp = UserDao_Impl.this.__ekoRolesTypeConverter.ekoRolesToString(value.getRoles());
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp);
                }
                String _tmp_1 = UserDao_Impl.this.__ekoPermissionsTypeConverter.ekoPermissionsToString(value.getPermissions());
                if (_tmp_1 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_1);
                }
                stmt.bindLong(7, (long)value.getFlagCount());
                String _tmp_2 = UserDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp_2 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_2);
                }
                if (value.getAvatarFileId() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getAvatarFileId());
                }
                if (value.getAvatarCustomUrl() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getAvatarCustomUrl());
                }
                if (value.getDescription() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getDescription());
                }
                int _tmp_3 = value.isGlobalBan() ? 1 : 0;
                stmt.bindLong(12, (long)_tmp_3);
                int _tmp_4 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(13, (long)_tmp_4);
                int _tmp_5 = value.isBrand() ? 1 : 0;
                stmt.bindLong(14, (long)_tmp_5);
                String _tmp_6 = UserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLastHeartbeat());
                if (_tmp_6 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, _tmp_6);
                }
                String _tmp_7 = UserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, _tmp_7);
                }
                String _tmp_8 = UserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_8 == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, _tmp_8);
                }
                String _tmp_9 = UserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_9 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_9);
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, value.getUserId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from user";
                return "DELETE from user";
            }
        };
        this.__preparedStmtOfDeleteById = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from user where userId = ?";
                return "DELETE from user where userId = ?";
            }
        };
    }

    @Override
    public void insertImpl(UserEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfUserEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends UserEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfUserEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(UserEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfUserEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends UserEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfUserEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(UserEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfUserEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(UserEntity object) {
        this.__db.beginTransaction();
        try {
            UserDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends UserEntity> objects) {
        this.__db.beginTransaction();
        try {
            UserDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(UserEntity object) {
        this.__db.beginTransaction();
        try {
            UserDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteById(String userId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteById.acquire();
        int _argIndex = 1;
        if (userId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, userId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteById.release(_stmt);
        }
    }

    @Override
    PagingSource<Integer, UserEntity> getPagingSourceImpl(String keyword, String sortBy) {
        String _sql = "SELECT * from user, user_query_token where (user.displayName like '%' || ? || '%' or user.userId like '%' || ? || '%') and (user_query_token.keyword = ? and user_query_token.sortBy = ? and user_query_token.ids like '%' || user.userId || '%') order by user.displayName asc";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from user, user_query_token where (user.displayName like '%' || ? || '%' or user.userId like '%' || ? || '%') and (user_query_token.keyword = ? and user_query_token.sortBy = ? and user_query_token.ids like '%' || user.userId || '%') order by user.displayName asc", (int)4);
        int _argIndex = 1;
        if (keyword == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, keyword);
        }
        _argIndex = 2;
        if (keyword == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, keyword);
        }
        _argIndex = 3;
        if (keyword == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, keyword);
        }
        _argIndex = 4;
        if (sortBy == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, sortBy);
        }
        return new LimitOffsetPagingSource<UserEntity>(_statement, this.__db, new String[]{"user", "user_query_token"}){

            protected List<UserEntity> convertRows(Cursor cursor) {
                int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"userId");
                int _cursorIndexOfMid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"mid");
                int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"path");
                int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"displayName");
                int _cursorIndexOfRoles = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"roles");
                int _cursorIndexOfPermissions = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"permissions");
                int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"flagCount");
                int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"metadata");
                int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"avatarFileId");
                int _cursorIndexOfAvatarCustomUrl = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"avatarCustomUrl");
                int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"description");
                int _cursorIndexOfIsGlobalBan = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isGlobalBan");
                int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isDeleted");
                int _cursorIndexOfIsBrand = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isBrand");
                int _cursorIndexOfLastHeartbeat = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"lastHeartbeat");
                int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"createdAt");
                int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"expiresAt");
                ArrayList<UserEntity> _result = new ArrayList<UserEntity>(cursor.getCount());
                while (cursor.moveToNext()) {
                    String _tmpUserId = cursor.isNull(_cursorIndexOfUserId) ? null : cursor.getString(_cursorIndexOfUserId);
                    String _tmpMid = cursor.isNull(_cursorIndexOfMid) ? null : cursor.getString(_cursorIndexOfMid);
                    String _tmpPath = cursor.isNull(_cursorIndexOfPath) ? null : cursor.getString(_cursorIndexOfPath);
                    String _tmpDisplayName = cursor.isNull(_cursorIndexOfDisplayName) ? null : cursor.getString(_cursorIndexOfDisplayName);
                    String _tmp = cursor.isNull(_cursorIndexOfRoles) ? null : cursor.getString(_cursorIndexOfRoles);
                    AmityRoles _tmpRoles = UserDao_Impl.this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp);
                    String _tmp_1 = cursor.isNull(_cursorIndexOfPermissions) ? null : cursor.getString(_cursorIndexOfPermissions);
                    AmityPermissions _tmpPermissions = UserDao_Impl.this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_1);
                    int _tmpFlagCount = cursor.getInt(_cursorIndexOfFlagCount);
                    String _tmp_2 = cursor.isNull(_cursorIndexOfMetadata) ? null : cursor.getString(_cursorIndexOfMetadata);
                    JsonObject _tmpMetadata = UserDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                    String _tmpAvatarFileId = cursor.isNull(_cursorIndexOfAvatarFileId) ? null : cursor.getString(_cursorIndexOfAvatarFileId);
                    String _tmpAvatarCustomUrl = cursor.isNull(_cursorIndexOfAvatarCustomUrl) ? null : cursor.getString(_cursorIndexOfAvatarCustomUrl);
                    String _tmpDescription = cursor.isNull(_cursorIndexOfDescription) ? null : cursor.getString(_cursorIndexOfDescription);
                    int _tmp_3 = cursor.getInt(_cursorIndexOfIsGlobalBan);
                    boolean _tmpIsGlobalBan = _tmp_3 != 0;
                    int _tmp_4 = cursor.getInt(_cursorIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_4 != 0;
                    int _tmp_5 = cursor.getInt(_cursorIndexOfIsBrand);
                    boolean _tmpIsBrand = _tmp_5 != 0;
                    String _tmp_6 = cursor.isNull(_cursorIndexOfLastHeartbeat) ? null : cursor.getString(_cursorIndexOfLastHeartbeat);
                    DateTime _tmpLastHeartbeat = UserDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    UserEntity _item = new UserEntity(_tmpUserId, _tmpMid, _tmpPath, _tmpDisplayName, _tmpRoles, _tmpPermissions, _tmpFlagCount, _tmpMetadata, _tmpAvatarFileId, _tmpAvatarCustomUrl, _tmpDescription, _tmpIsGlobalBan, _tmpIsDeleted, _tmpIsBrand, _tmpLastHeartbeat);
                    String _tmp_7 = cursor.isNull(_cursorIndexOfCreatedAt) ? null : cursor.getString(_cursorIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = UserDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_8 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = UserDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_9 = cursor.isNull(_cursorIndexOfExpiresAt) ? null : cursor.getString(_cursorIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = UserDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                return _result;
            }
        };
    }

    @Override
    Flowable<UserEntity> getByIdImpl(String userId) {
        String _sql = "SELECT * from user where user.userId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from user where user.userId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"user"}, (Callable)new Callable<UserEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UserEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)UserDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    UserEntity _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfMid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mid");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
                    int _cursorIndexOfRoles = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"roles");
                    int _cursorIndexOfPermissions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"permissions");
                    int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarFileId");
                    int _cursorIndexOfAvatarCustomUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarCustomUrl");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfIsGlobalBan = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isGlobalBan");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfIsBrand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isBrand");
                    int _cursorIndexOfLastHeartbeat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastHeartbeat");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        String _tmpMid = _cursor.isNull(_cursorIndexOfMid) ? null : _cursor.getString(_cursorIndexOfMid);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                        String _tmp = _cursor.isNull(_cursorIndexOfRoles) ? null : _cursor.getString(_cursorIndexOfRoles);
                        AmityRoles _tmpRoles = UserDao_Impl.this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfPermissions) ? null : _cursor.getString(_cursorIndexOfPermissions);
                        AmityPermissions _tmpPermissions = UserDao_Impl.this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_1);
                        int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = UserDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                        String _tmpAvatarFileId = _cursor.isNull(_cursorIndexOfAvatarFileId) ? null : _cursor.getString(_cursorIndexOfAvatarFileId);
                        String _tmpAvatarCustomUrl = _cursor.isNull(_cursorIndexOfAvatarCustomUrl) ? null : _cursor.getString(_cursorIndexOfAvatarCustomUrl);
                        String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsGlobalBan);
                        boolean _tmpIsGlobalBan = _tmp_3 != 0;
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_4 != 0;
                        int _tmp_5 = _cursor.getInt(_cursorIndexOfIsBrand);
                        boolean _tmpIsBrand = _tmp_5 != 0;
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfLastHeartbeat) ? null : _cursor.getString(_cursorIndexOfLastHeartbeat);
                        DateTime _tmpLastHeartbeat = UserDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                        _result = new UserEntity(_tmpUserId, _tmpMid, _tmpPath, _tmpDisplayName, _tmpRoles, _tmpPermissions, _tmpFlagCount, _tmpMetadata, _tmpAvatarFileId, _tmpAvatarCustomUrl, _tmpDescription, _tmpIsGlobalBan, _tmpIsDeleted, _tmpIsBrand, _tmpLastHeartbeat);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = UserDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_8 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = UserDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = UserDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    UserEntity userEntity = _result;
                    return userEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    Flowable<List<UserEntity>> observeUserImpl(String userId) {
        String _sql = "SELECT * from user where user.userId IN (?)";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from user where user.userId IN (?)", (int)1);
        int _argIndex = 1;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"user"}, (Callable)new Callable<List<UserEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<UserEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)UserDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfMid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mid");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
                    int _cursorIndexOfRoles = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"roles");
                    int _cursorIndexOfPermissions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"permissions");
                    int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarFileId");
                    int _cursorIndexOfAvatarCustomUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarCustomUrl");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfIsGlobalBan = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isGlobalBan");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfIsBrand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isBrand");
                    int _cursorIndexOfLastHeartbeat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastHeartbeat");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    ArrayList<UserEntity> _result = new ArrayList<UserEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        String _tmpMid = _cursor.isNull(_cursorIndexOfMid) ? null : _cursor.getString(_cursorIndexOfMid);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                        String _tmp = _cursor.isNull(_cursorIndexOfRoles) ? null : _cursor.getString(_cursorIndexOfRoles);
                        AmityRoles _tmpRoles = UserDao_Impl.this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfPermissions) ? null : _cursor.getString(_cursorIndexOfPermissions);
                        AmityPermissions _tmpPermissions = UserDao_Impl.this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_1);
                        int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = UserDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                        String _tmpAvatarFileId = _cursor.isNull(_cursorIndexOfAvatarFileId) ? null : _cursor.getString(_cursorIndexOfAvatarFileId);
                        String _tmpAvatarCustomUrl = _cursor.isNull(_cursorIndexOfAvatarCustomUrl) ? null : _cursor.getString(_cursorIndexOfAvatarCustomUrl);
                        String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsGlobalBan);
                        boolean _tmpIsGlobalBan = _tmp_3 != 0;
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_4 != 0;
                        int _tmp_5 = _cursor.getInt(_cursorIndexOfIsBrand);
                        boolean _tmpIsBrand = _tmp_5 != 0;
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfLastHeartbeat) ? null : _cursor.getString(_cursorIndexOfLastHeartbeat);
                        DateTime _tmpLastHeartbeat = UserDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                        UserEntity _item = new UserEntity(_tmpUserId, _tmpMid, _tmpPath, _tmpDisplayName, _tmpRoles, _tmpPermissions, _tmpFlagCount, _tmpMetadata, _tmpAvatarFileId, _tmpAvatarCustomUrl, _tmpDescription, _tmpIsGlobalBan, _tmpIsDeleted, _tmpIsBrand, _tmpLastHeartbeat);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = UserDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                        _item.setCreatedAt(_tmpCreatedAt);
                        String _tmp_8 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = UserDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                        _item.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = UserDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                        _item.setExpiresAt(_tmpExpiresAt);
                        _result.add(_item);
                    }
                    ArrayList<UserEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    UserEntity getByIdNowImpl(String userId) {
        String _sql = "SELECT * from user where user.userId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from user where user.userId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            UserEntity _result;
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfMid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mid");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
            int _cursorIndexOfRoles = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"roles");
            int _cursorIndexOfPermissions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"permissions");
            int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarFileId");
            int _cursorIndexOfAvatarCustomUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarCustomUrl");
            int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
            int _cursorIndexOfIsGlobalBan = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isGlobalBan");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfIsBrand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isBrand");
            int _cursorIndexOfLastHeartbeat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastHeartbeat");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                String _tmpMid = _cursor.isNull(_cursorIndexOfMid) ? null : _cursor.getString(_cursorIndexOfMid);
                String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                String _tmp = _cursor.isNull(_cursorIndexOfRoles) ? null : _cursor.getString(_cursorIndexOfRoles);
                AmityRoles _tmpRoles = this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfPermissions) ? null : _cursor.getString(_cursorIndexOfPermissions);
                AmityPermissions _tmpPermissions = this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_1);
                int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                String _tmpAvatarFileId = _cursor.isNull(_cursorIndexOfAvatarFileId) ? null : _cursor.getString(_cursorIndexOfAvatarFileId);
                String _tmpAvatarCustomUrl = _cursor.isNull(_cursorIndexOfAvatarCustomUrl) ? null : _cursor.getString(_cursorIndexOfAvatarCustomUrl);
                String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfIsGlobalBan);
                boolean _tmpIsGlobalBan = _tmp_3 != 0;
                int _tmp_4 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_4 != 0;
                int _tmp_5 = _cursor.getInt(_cursorIndexOfIsBrand);
                boolean _tmpIsBrand = _tmp_5 != 0;
                String _tmp_6 = _cursor.isNull(_cursorIndexOfLastHeartbeat) ? null : _cursor.getString(_cursorIndexOfLastHeartbeat);
                DateTime _tmpLastHeartbeat = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                _result = new UserEntity(_tmpUserId, _tmpMid, _tmpPath, _tmpDisplayName, _tmpRoles, _tmpPermissions, _tmpFlagCount, _tmpMetadata, _tmpAvatarFileId, _tmpAvatarCustomUrl, _tmpDescription, _tmpIsGlobalBan, _tmpIsDeleted, _tmpIsBrand, _tmpLastHeartbeat);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_8 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_9 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            UserEntity userEntity = _result;
            return userEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<UserEntity> getByIdsNowImpl(List<String> userIds) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from user where user.userId IN (");
        int _inputSize = userIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : userIds) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfMid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mid");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
            int _cursorIndexOfRoles = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"roles");
            int _cursorIndexOfPermissions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"permissions");
            int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarFileId");
            int _cursorIndexOfAvatarCustomUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarCustomUrl");
            int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
            int _cursorIndexOfIsGlobalBan = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isGlobalBan");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfIsBrand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isBrand");
            int _cursorIndexOfLastHeartbeat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastHeartbeat");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            ArrayList<UserEntity> _result = new ArrayList<UserEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                String _tmpMid = _cursor.isNull(_cursorIndexOfMid) ? null : _cursor.getString(_cursorIndexOfMid);
                String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                String _tmp = _cursor.isNull(_cursorIndexOfRoles) ? null : _cursor.getString(_cursorIndexOfRoles);
                AmityRoles _tmpRoles = this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfPermissions) ? null : _cursor.getString(_cursorIndexOfPermissions);
                AmityPermissions _tmpPermissions = this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_1);
                int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                String _tmpAvatarFileId = _cursor.isNull(_cursorIndexOfAvatarFileId) ? null : _cursor.getString(_cursorIndexOfAvatarFileId);
                String _tmpAvatarCustomUrl = _cursor.isNull(_cursorIndexOfAvatarCustomUrl) ? null : _cursor.getString(_cursorIndexOfAvatarCustomUrl);
                String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfIsGlobalBan);
                boolean _tmpIsGlobalBan = _tmp_3 != 0;
                int _tmp_4 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_4 != 0;
                int _tmp_5 = _cursor.getInt(_cursorIndexOfIsBrand);
                boolean _tmpIsBrand = _tmp_5 != 0;
                String _tmp_6 = _cursor.isNull(_cursorIndexOfLastHeartbeat) ? null : _cursor.getString(_cursorIndexOfLastHeartbeat);
                DateTime _tmpLastHeartbeat = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                UserEntity _item_1 = new UserEntity(_tmpUserId, _tmpMid, _tmpPath, _tmpDisplayName, _tmpRoles, _tmpPermissions, _tmpFlagCount, _tmpMetadata, _tmpAvatarFileId, _tmpAvatarCustomUrl, _tmpDescription, _tmpIsGlobalBan, _tmpIsDeleted, _tmpIsBrand, _tmpLastHeartbeat);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _item_1.setCreatedAt(_tmpCreatedAt);
                String _tmp_8 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                _item_1.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_9 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                _item_1.setExpiresAt(_tmpExpiresAt);
                _result.add(_item_1);
            }
            ArrayList<UserEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    Flowable<List<UserEntity>> getByUserIdsImpl(List<String> userIds) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from user where user.userId IN (");
        int _inputSize = userIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : userIds) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"user"}, (Callable)new Callable<List<UserEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<UserEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)UserDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfMid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mid");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
                    int _cursorIndexOfRoles = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"roles");
                    int _cursorIndexOfPermissions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"permissions");
                    int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarFileId");
                    int _cursorIndexOfAvatarCustomUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarCustomUrl");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfIsGlobalBan = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isGlobalBan");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfIsBrand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isBrand");
                    int _cursorIndexOfLastHeartbeat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastHeartbeat");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    ArrayList<UserEntity> _result = new ArrayList<UserEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        String _tmpMid = _cursor.isNull(_cursorIndexOfMid) ? null : _cursor.getString(_cursorIndexOfMid);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                        String _tmp = _cursor.isNull(_cursorIndexOfRoles) ? null : _cursor.getString(_cursorIndexOfRoles);
                        AmityRoles _tmpRoles = UserDao_Impl.this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfPermissions) ? null : _cursor.getString(_cursorIndexOfPermissions);
                        AmityPermissions _tmpPermissions = UserDao_Impl.this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_1);
                        int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = UserDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                        String _tmpAvatarFileId = _cursor.isNull(_cursorIndexOfAvatarFileId) ? null : _cursor.getString(_cursorIndexOfAvatarFileId);
                        String _tmpAvatarCustomUrl = _cursor.isNull(_cursorIndexOfAvatarCustomUrl) ? null : _cursor.getString(_cursorIndexOfAvatarCustomUrl);
                        String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsGlobalBan);
                        boolean _tmpIsGlobalBan = _tmp_3 != 0;
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_4 != 0;
                        int _tmp_5 = _cursor.getInt(_cursorIndexOfIsBrand);
                        boolean _tmpIsBrand = _tmp_5 != 0;
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfLastHeartbeat) ? null : _cursor.getString(_cursorIndexOfLastHeartbeat);
                        DateTime _tmpLastHeartbeat = UserDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                        UserEntity _item_1 = new UserEntity(_tmpUserId, _tmpMid, _tmpPath, _tmpDisplayName, _tmpRoles, _tmpPermissions, _tmpFlagCount, _tmpMetadata, _tmpAvatarFileId, _tmpAvatarCustomUrl, _tmpDescription, _tmpIsGlobalBan, _tmpIsDeleted, _tmpIsBrand, _tmpLastHeartbeat);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = UserDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                        _item_1.setCreatedAt(_tmpCreatedAt);
                        String _tmp_8 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = UserDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                        _item_1.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = UserDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                        _item_1.setExpiresAt(_tmpExpiresAt);
                        _result.add(_item_1);
                    }
                    ArrayList<UserEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

