/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.invitation;

import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import co.amity.rxbridge.FlowableKt;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.core.data.invitation.InvitationLocalDataStore;
import com.amity.socialcloud.sdk.core.data.invitation.InvitationModelMapper;
import com.amity.socialcloud.sdk.core.data.invitation.InvitationRemoteDataStore;
import com.amity.socialcloud.sdk.core.data.invitation.InvitationRepository;
import com.amity.socialcloud.sdk.core.data.reaction.paging.InvitationMediator;
import com.amity.socialcloud.sdk.model.core.invitation.AmityInvitation;
import com.amity.socialcloud.sdk.model.core.invitation.AmityInvitationStatus;
import com.amity.socialcloud.sdk.model.core.invitation.AmityInvitationType;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.internal.api.socket.request.CreateInvitationsRequest;
import com.ekoapp.ekosdk.internal.data.model.InvitationEntity;
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagerCreator;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001c\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bJ\b\u0010\f\u001a\u00020\rH\u0002J\"\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u001a\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u000b0\u00172\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0019"}, d2={"Lcom/amity/socialcloud/sdk/core/data/invitation/InvitationRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "()V", "acceptInvitation", "Lio/reactivex/rxjava3/core/Completable;", "invitationId", "", "cancelInvitation", "createCommunityInvitations", "communityId", "userIds", "", "getDefaultPageSize", "", "getInvitationPagingData", "Lio/reactivex/rxjava3/core/Flowable;", "Landroidx/paging/PagingData;", "Lcom/amity/socialcloud/sdk/model/core/invitation/AmityInvitation;", "type", "Lcom/amity/socialcloud/sdk/model/core/invitation/AmityInvitationType;", "target", "Lcom/amity/socialcloud/sdk/core/data/reaction/paging/InvitationMediator$Target;", "getMyCommunityInvitation", "Lio/reactivex/rxjava3/core/Single;", "rejectInvitation", "amity-sdk_release"})
public final class InvitationRepository
extends EkoObjectRepository {
    private final int getDefaultPageSize() {
        return 15;
    }

    @NotNull
    public final Flowable<PagingData<AmityInvitation>> getInvitationPagingData(@NotNull AmityInvitationType type2, @NotNull InvitationMediator.Target target) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        DynamicQueryStreamPagerCreator pagerCreator2 = new DynamicQueryStreamPagerCreator(new PagingConfig(this.getDefaultPageSize(), 0, false, 0, 0, 0, 58, null), null, new InvitationMediator(type2, target), (Function0)new Function0<PagingSource<Integer, InvitationEntity>>(type2, target){
            final /* synthetic */ AmityInvitationType $type;
            final /* synthetic */ InvitationMediator.Target $target;
            {
                this.$type = $type;
                this.$target = $target;
                super(0);
            }

            @NotNull
            public final PagingSource<Integer, InvitationEntity> invoke() {
                return new InvitationLocalDataStore().getInvitationsPagingSource(this.$type, this.$target);
            }
        }, (ModelMapper)new InvitationModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator2.create());
    }

    @NotNull
    public final Single<List<AmityInvitation>> getMyCommunityInvitation(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Single single = InvitationRemoteDataStore.getMyInvitations$default(new InvitationRemoteDataStore(), AmityInvitationType.COMMUNITY_MEMBER, new InvitationMediator.Target.COMMUNITY(communityId), null, null, 12, null).flatMap((Function)getMyCommunityInvitation.1.INSTANCE).map((Function)getMyCommunityInvitation.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"InvitationRemoteDataStor\u2026          }\n            }");
        return single;
    }

    @NotNull
    public final Completable createCommunityInvitations(@NotNull String communityId, @NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        Completable completable = new InvitationRemoteDataStore().createInvitations(new CreateInvitationsRequest(AmityInvitationType.COMMUNITY_MEMBER.getValue(), communityId, "community", userIds)).flatMapCompletable((Function)createCommunityInvitations.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"InvitationRemoteDataStor\u2026ersist(dto)\n            }");
        return completable;
    }

    @NotNull
    public final Completable acceptInvitation(@NotNull String invitationId) {
        Intrinsics.checkNotNullParameter((Object)invitationId, (String)"invitationId");
        Completable completable = new InvitationRemoteDataStore().acceptInvitations(invitationId).doOnSuccess(new Consumer(invitationId){
            final /* synthetic */ String $invitationId;
            {
                this.$invitationId = $invitationId;
            }

            public final void accept(@NotNull JsonObject it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                new InvitationLocalDataStore().updateStatus(this.$invitationId, AmityInvitationStatus.APPROVED);
            }
        }).subscribeOn(Schedulers.io()).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"invitationId: String): C\u2026         .ignoreElement()");
        return completable;
    }

    @NotNull
    public final Completable rejectInvitation(@NotNull String invitationId) {
        Intrinsics.checkNotNullParameter((Object)invitationId, (String)"invitationId");
        Completable completable = new InvitationRemoteDataStore().rejectInvitations(invitationId).doOnSuccess(new Consumer(invitationId){
            final /* synthetic */ String $invitationId;
            {
                this.$invitationId = $invitationId;
            }

            public final void accept(@NotNull JsonObject it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                new InvitationLocalDataStore().updateStatus(this.$invitationId, AmityInvitationStatus.REJECTED);
            }
        }).subscribeOn(Schedulers.io()).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"invitationId: String): C\u2026         .ignoreElement()");
        return completable;
    }

    @NotNull
    public final Completable cancelInvitation(@NotNull String invitationId) {
        Intrinsics.checkNotNullParameter((Object)invitationId, (String)"invitationId");
        Completable completable = new InvitationRemoteDataStore().cancelInvitations(invitationId).doOnSuccess(new Consumer(invitationId){
            final /* synthetic */ String $invitationId;
            {
                this.$invitationId = $invitationId;
            }

            public final void accept(@NotNull JsonObject it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                new InvitationLocalDataStore().updateStatus(this.$invitationId, AmityInvitationStatus.CANCELLED);
            }
        }).subscribeOn(Schedulers.io()).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"invitationId: String): C\u2026         .ignoreElement()");
        return completable;
    }
}

