/*
 * Copyright 2008-present MongoDB, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.amity.diagnostics

import org.amity.assertions.Assertions.notNull

/**
 * This class is not part of the public API.
 *
 * @since 3.0
 */
object Loggers {
	/**
	 * The prefix for all logger names.
	 */
	const val PREFIX = "org.bson"
	private val USE_SLF4J = shouldUseSLF4J()
	
	/**
	 * Gets a logger with the given suffix appended on to `PREFIX`, separated by a '.'.
	 *
	 * @param suffix the suffix for the logger
	 * @return the logger
	 * @see Loggers.PREFIX
	 */
    @JvmStatic
    fun getLogger(suffix: String): Logger {
		notNull("suffix", suffix)
		require(!(suffix.startsWith(".") || suffix.endsWith("."))) { "The suffix can not start or end with a '.'" }
		val name = "$PREFIX.$suffix"
		return TimberLogger(name)
	}
	
	private fun shouldUseSLF4J(): Boolean {
		return try {
			Class.forName("org.slf4j.Logger")
			true
		} catch (e: ClassNotFoundException) {
			false
		}
	}
}