package com.amity.socialcloud.sdk.api.social.post.create.datatype

import com.amity.socialcloud.sdk.core.mention.AmityMentionType
import com.amity.socialcloud.sdk.model.core.mention.AmityMentioneeTarget
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.google.gson.JsonObject

class AmityLiveStreamPostCreator private constructor(
    targetType: String,
    targetId: String,
    private val text: String,
    private val streamId: String,
    metadata: JsonObject?,
    mentionees: List<AmityMentioneeTarget>?
) : AmityPostCreator(targetType, targetId, metadata, mentionees) {

    class Builder {
        private var targetType = ""
        private var targetId = ""
        private var text = ""
        private var streamId = ""
        private var metadata: JsonObject? = null
        private var mentionees: List<AmityMentioneeTarget>? = null

        internal fun targetType(targetType: String): Builder {
            this.targetType = targetType
            return this
        }

        internal fun targetId(targetId: String): Builder {
            this.targetId = targetId
            return this
        }

        /**
         * @param [text] to add text to the post
         * @return the same instance of AmityLiveStreamPostCreator.Builder
         */
        fun text(text: String): Builder {
            this.text = text
            return this
        }

        /**
         * @param [streamId] to add stream as child
         * @return the same instance of AmityLiveStreamPostCreator.Builder
         */
        fun streamId(streamId: String): Builder {
            this.streamId = streamId
            return this
        }

        /**
         * @param [metadata] to add metadata to the post
         * @return the same instance of AmityLiveStreamPostCreator.Builder
         */
        fun metadata(metadata: JsonObject): Builder {
            this.metadata = metadata
            return this
        }

        /**
         * @param [userIds] list of userId of users to be mentioned by this post
         * @return the same instance of AmityLiveStreamPostCreator.Builder
         */
        fun mentionUsers(userIds: List<String>): Builder {
            this.mentionees = listOf(AmityMentioneeTarget(AmityMentionType.USER.apiKey, userIds))
            return this
        }

        /**
         * Instantiates AmityLiveStreamPostCreator with built params.
         * @return new instance of AmityLiveStreamPostCreator.
         */
        fun build(): AmityLiveStreamPostCreator {
            return AmityLiveStreamPostCreator(targetType, targetId, text, streamId, metadata, mentionees)
        }
    }

    override fun isCustomDataType(): Boolean {
        return true
    }

    override fun getPostDataType(): AmityPost.DataType {
        return AmityPost.DataType.LIVE_STREAM
    }

    override fun composeData(): JsonObject {
        val data = JsonObject()
        data.addProperty(TEXT_DATA_KEY, getText())
        data.addProperty(STREAM_DATA_KEY, streamId)
        return data
    }

    override fun getText(): String {
        return text
    }
}

private const val STREAM_DATA_KEY = "streamId"