/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.MessagePreviewDao;
import com.ekoapp.ekosdk.internal.data.model.MessagePreviewEntity;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class MessagePreviewDao_Impl
extends MessagePreviewDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<MessagePreviewEntity> __insertionAdapterOfMessagePreviewEntity;
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<MessagePreviewEntity> __deletionAdapterOfMessagePreviewEntity;
    private final EntityDeletionOrUpdateAdapter<MessagePreviewEntity> __updateAdapterOfMessagePreviewEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteById;
    private final SharedSQLiteStatement __preparedStmtOfUpdateSubChannelInfo;
    private final SharedSQLiteStatement __preparedStmtOfClearDeletedMessagePreviews;

    public MessagePreviewDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfMessagePreviewEntity = new EntityInsertionAdapter<MessagePreviewEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `message_preview` (`messagePreviewId`,`dataType`,`data`,`channelId`,`subChannelId`,`subChannelName`,`subChannelUpdatedAt`,`creatorId`,`isDeleted`,`segment`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, MessagePreviewEntity value) {
                if (value.getMessagePreviewId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMessagePreviewId());
                }
                if (value.getDataType() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getDataType());
                }
                String _tmp = MessagePreviewDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getData());
                if (_tmp == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp);
                }
                if (value.getChannelId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getChannelId());
                }
                if (value.getSubChannelId() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getSubChannelId());
                }
                if (value.getSubChannelName() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getSubChannelName());
                }
                String _tmp_1 = MessagePreviewDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getSubChannelUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_1);
                }
                if (value.getCreatorId() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getCreatorId());
                }
                int _tmp_2 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(9, (long)_tmp_2);
                stmt.bindLong(10, (long)value.getSegment());
                String _tmp_3 = MessagePreviewDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_3);
                }
                String _tmp_4 = MessagePreviewDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_4);
                }
                String _tmp_5 = MessagePreviewDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_5 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, _tmp_5);
                }
            }
        };
        this.__deletionAdapterOfMessagePreviewEntity = new EntityDeletionOrUpdateAdapter<MessagePreviewEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `message_preview` WHERE `subChannelId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, MessagePreviewEntity value) {
                if (value.getSubChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getSubChannelId());
                }
            }
        };
        this.__updateAdapterOfMessagePreviewEntity = new EntityDeletionOrUpdateAdapter<MessagePreviewEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `message_preview` SET `messagePreviewId` = ?,`dataType` = ?,`data` = ?,`channelId` = ?,`subChannelId` = ?,`subChannelName` = ?,`subChannelUpdatedAt` = ?,`creatorId` = ?,`isDeleted` = ?,`segment` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `subChannelId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, MessagePreviewEntity value) {
                if (value.getMessagePreviewId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMessagePreviewId());
                }
                if (value.getDataType() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getDataType());
                }
                String _tmp = MessagePreviewDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getData());
                if (_tmp == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp);
                }
                if (value.getChannelId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getChannelId());
                }
                if (value.getSubChannelId() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getSubChannelId());
                }
                if (value.getSubChannelName() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getSubChannelName());
                }
                String _tmp_1 = MessagePreviewDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getSubChannelUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_1);
                }
                if (value.getCreatorId() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getCreatorId());
                }
                int _tmp_2 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(9, (long)_tmp_2);
                stmt.bindLong(10, (long)value.getSegment());
                String _tmp_3 = MessagePreviewDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_3);
                }
                String _tmp_4 = MessagePreviewDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_4);
                }
                String _tmp_5 = MessagePreviewDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_5 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, _tmp_5);
                }
                if (value.getSubChannelId() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.getSubChannelId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from message_preview";
                return "DELETE from message_preview";
            }
        };
        this.__preparedStmtOfDeleteById = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from message_preview where messagePreviewId = ?";
                return "DELETE from message_preview where messagePreviewId = ?";
            }
        };
        this.__preparedStmtOfUpdateSubChannelInfo = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE message_preview set subChannelName = ?, subChannelUpdatedAt = ? where subChannelId = ?";
                return "UPDATE message_preview set subChannelName = ?, subChannelUpdatedAt = ? where subChannelId = ?";
            }
        };
        this.__preparedStmtOfClearDeletedMessagePreviews = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from message_preview where isDeleted != 0";
                return "DELETE from message_preview where isDeleted != 0";
            }
        };
    }

    @Override
    public void insertImpl(MessagePreviewEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfMessagePreviewEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends MessagePreviewEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfMessagePreviewEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(MessagePreviewEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfMessagePreviewEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends MessagePreviewEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfMessagePreviewEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(MessagePreviewEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfMessagePreviewEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(MessagePreviewEntity object) {
        this.__db.beginTransaction();
        try {
            MessagePreviewDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends MessagePreviewEntity> objects) {
        this.__db.beginTransaction();
        try {
            MessagePreviewDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(MessagePreviewEntity object) {
        this.__db.beginTransaction();
        try {
            MessagePreviewDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteById(String messagePreviewId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteById.acquire();
        int _argIndex = 1;
        if (messagePreviewId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, messagePreviewId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteById.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSubChannelInfo(String subChannelId, String subChannelName, DateTime subChannelUpdatedAt) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateSubChannelInfo.acquire();
        int _argIndex = 1;
        if (subChannelName == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, subChannelName);
        }
        _argIndex = 2;
        String _tmp = this.__dateTimeTypeConverter.dateTimeToString(subChannelUpdatedAt);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 3;
        if (subChannelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, subChannelId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateSubChannelInfo.release(_stmt);
        }
    }

    @Override
    public void clearDeletedMessagePreviews() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClearDeletedMessagePreviews.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClearDeletedMessagePreviews.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessagePreviewEntity getByIdNow(String subChannelId) {
        String _sql = "SELECT * from message_preview where subChannelId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from message_preview where subChannelId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (subChannelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, subChannelId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            MessagePreviewEntity _result;
            int _cursorIndexOfMessagePreviewId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messagePreviewId");
            int _cursorIndexOfDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataType");
            int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfSubChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelId");
            int _cursorIndexOfSubChannelName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelName");
            int _cursorIndexOfSubChannelUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelUpdatedAt");
            int _cursorIndexOfCreatorId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"creatorId");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"segment");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                String _tmpMessagePreviewId = _cursor.isNull(_cursorIndexOfMessagePreviewId) ? null : _cursor.getString(_cursorIndexOfMessagePreviewId);
                String _tmpDataType = _cursor.isNull(_cursorIndexOfDataType) ? null : _cursor.getString(_cursorIndexOfDataType);
                String _tmp = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                String _tmpSubChannelId = _cursor.isNull(_cursorIndexOfSubChannelId) ? null : _cursor.getString(_cursorIndexOfSubChannelId);
                String _tmpSubChannelName = _cursor.isNull(_cursorIndexOfSubChannelName) ? null : _cursor.getString(_cursorIndexOfSubChannelName);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfSubChannelUpdatedAt) ? null : _cursor.getString(_cursorIndexOfSubChannelUpdatedAt);
                DateTime _tmpSubChannelUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                String _tmpCreatorId = _cursor.isNull(_cursorIndexOfCreatorId) ? null : _cursor.getString(_cursorIndexOfCreatorId);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_2 != 0;
                int _tmpSegment = _cursor.getInt(_cursorIndexOfSegment);
                _result = new MessagePreviewEntity(_tmpMessagePreviewId, _tmpDataType, _tmpData, _tmpChannelId, _tmpSubChannelId, _tmpSubChannelName, _tmpSubChannelUpdatedAt, _tmpCreatorId, _tmpIsDeleted, _tmpSegment);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_5 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            MessagePreviewEntity messagePreviewEntity = _result;
            return messagePreviewEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessagePreviewEntity> getByIdsNow(List<String> subChannelIds) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from message_preview where message_preview.subChannelId IN (");
        int _inputSize = subChannelIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : subChannelIds) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfMessagePreviewId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messagePreviewId");
            int _cursorIndexOfDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataType");
            int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfSubChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelId");
            int _cursorIndexOfSubChannelName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelName");
            int _cursorIndexOfSubChannelUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelUpdatedAt");
            int _cursorIndexOfCreatorId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"creatorId");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"segment");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            ArrayList<MessagePreviewEntity> _result = new ArrayList<MessagePreviewEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpMessagePreviewId = _cursor.isNull(_cursorIndexOfMessagePreviewId) ? null : _cursor.getString(_cursorIndexOfMessagePreviewId);
                String _tmpDataType = _cursor.isNull(_cursorIndexOfDataType) ? null : _cursor.getString(_cursorIndexOfDataType);
                String _tmp = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                String _tmpSubChannelId = _cursor.isNull(_cursorIndexOfSubChannelId) ? null : _cursor.getString(_cursorIndexOfSubChannelId);
                String _tmpSubChannelName = _cursor.isNull(_cursorIndexOfSubChannelName) ? null : _cursor.getString(_cursorIndexOfSubChannelName);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfSubChannelUpdatedAt) ? null : _cursor.getString(_cursorIndexOfSubChannelUpdatedAt);
                DateTime _tmpSubChannelUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                String _tmpCreatorId = _cursor.isNull(_cursorIndexOfCreatorId) ? null : _cursor.getString(_cursorIndexOfCreatorId);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_2 != 0;
                int _tmpSegment = _cursor.getInt(_cursorIndexOfSegment);
                MessagePreviewEntity _item_1 = new MessagePreviewEntity(_tmpMessagePreviewId, _tmpDataType, _tmpData, _tmpChannelId, _tmpSubChannelId, _tmpSubChannelName, _tmpSubChannelUpdatedAt, _tmpCreatorId, _tmpIsDeleted, _tmpSegment);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                _item_1.setCreatedAt(_tmpCreatedAt);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                _item_1.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_5 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                _item_1.setExpiresAt(_tmpExpiresAt);
                _result.add(_item_1);
            }
            ArrayList<MessagePreviewEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Flowable<MessagePreviewEntity> getById(String messagePreviewId) {
        String _sql = "SELECT * from message_preview where messagePreviewId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from message_preview where messagePreviewId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (messagePreviewId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, messagePreviewId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"message_preview"}, (Callable)new Callable<MessagePreviewEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MessagePreviewEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)MessagePreviewDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    MessagePreviewEntity _result;
                    int _cursorIndexOfMessagePreviewId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messagePreviewId");
                    int _cursorIndexOfDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataType");
                    int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfSubChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelId");
                    int _cursorIndexOfSubChannelName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelName");
                    int _cursorIndexOfSubChannelUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelUpdatedAt");
                    int _cursorIndexOfCreatorId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"creatorId");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"segment");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        String _tmpMessagePreviewId = _cursor.isNull(_cursorIndexOfMessagePreviewId) ? null : _cursor.getString(_cursorIndexOfMessagePreviewId);
                        String _tmpDataType = _cursor.isNull(_cursorIndexOfDataType) ? null : _cursor.getString(_cursorIndexOfDataType);
                        String _tmp = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        JsonObject _tmpData = MessagePreviewDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        String _tmpSubChannelId = _cursor.isNull(_cursorIndexOfSubChannelId) ? null : _cursor.getString(_cursorIndexOfSubChannelId);
                        String _tmpSubChannelName = _cursor.isNull(_cursorIndexOfSubChannelName) ? null : _cursor.getString(_cursorIndexOfSubChannelName);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfSubChannelUpdatedAt) ? null : _cursor.getString(_cursorIndexOfSubChannelUpdatedAt);
                        DateTime _tmpSubChannelUpdatedAt = MessagePreviewDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        String _tmpCreatorId = _cursor.isNull(_cursorIndexOfCreatorId) ? null : _cursor.getString(_cursorIndexOfCreatorId);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_2 != 0;
                        int _tmpSegment = _cursor.getInt(_cursorIndexOfSegment);
                        _result = new MessagePreviewEntity(_tmpMessagePreviewId, _tmpDataType, _tmpData, _tmpChannelId, _tmpSubChannelId, _tmpSubChannelName, _tmpSubChannelUpdatedAt, _tmpCreatorId, _tmpIsDeleted, _tmpSegment);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = MessagePreviewDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = MessagePreviewDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = MessagePreviewDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    MessagePreviewEntity messagePreviewEntity = _result;
                    return messagePreviewEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessagePreviewEntity getByIdMessageIdNow(String messagePreviewId) {
        String _sql = "SELECT * from message_preview where messagePreviewId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from message_preview where messagePreviewId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (messagePreviewId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, messagePreviewId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            MessagePreviewEntity _result;
            int _cursorIndexOfMessagePreviewId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messagePreviewId");
            int _cursorIndexOfDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataType");
            int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfSubChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelId");
            int _cursorIndexOfSubChannelName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelName");
            int _cursorIndexOfSubChannelUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelUpdatedAt");
            int _cursorIndexOfCreatorId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"creatorId");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"segment");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                String _tmpMessagePreviewId = _cursor.isNull(_cursorIndexOfMessagePreviewId) ? null : _cursor.getString(_cursorIndexOfMessagePreviewId);
                String _tmpDataType = _cursor.isNull(_cursorIndexOfDataType) ? null : _cursor.getString(_cursorIndexOfDataType);
                String _tmp = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                String _tmpSubChannelId = _cursor.isNull(_cursorIndexOfSubChannelId) ? null : _cursor.getString(_cursorIndexOfSubChannelId);
                String _tmpSubChannelName = _cursor.isNull(_cursorIndexOfSubChannelName) ? null : _cursor.getString(_cursorIndexOfSubChannelName);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfSubChannelUpdatedAt) ? null : _cursor.getString(_cursorIndexOfSubChannelUpdatedAt);
                DateTime _tmpSubChannelUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                String _tmpCreatorId = _cursor.isNull(_cursorIndexOfCreatorId) ? null : _cursor.getString(_cursorIndexOfCreatorId);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_2 != 0;
                int _tmpSegment = _cursor.getInt(_cursorIndexOfSegment);
                _result = new MessagePreviewEntity(_tmpMessagePreviewId, _tmpDataType, _tmpData, _tmpChannelId, _tmpSubChannelId, _tmpSubChannelName, _tmpSubChannelUpdatedAt, _tmpCreatorId, _tmpIsDeleted, _tmpSegment);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_5 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            MessagePreviewEntity messagePreviewEntity = _result;
            return messagePreviewEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessagePreviewEntity getByChannelId(String channelId) {
        String _sql = "SELECT * from message_preview where channelId = ? order by updatedAt desc LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from message_preview where channelId = ? order by updatedAt desc LIMIT 1", (int)1);
        int _argIndex = 1;
        if (channelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, channelId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            MessagePreviewEntity _result;
            int _cursorIndexOfMessagePreviewId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messagePreviewId");
            int _cursorIndexOfDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataType");
            int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfSubChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelId");
            int _cursorIndexOfSubChannelName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelName");
            int _cursorIndexOfSubChannelUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelUpdatedAt");
            int _cursorIndexOfCreatorId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"creatorId");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"segment");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                String _tmpMessagePreviewId = _cursor.isNull(_cursorIndexOfMessagePreviewId) ? null : _cursor.getString(_cursorIndexOfMessagePreviewId);
                String _tmpDataType = _cursor.isNull(_cursorIndexOfDataType) ? null : _cursor.getString(_cursorIndexOfDataType);
                String _tmp = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                String _tmpSubChannelId = _cursor.isNull(_cursorIndexOfSubChannelId) ? null : _cursor.getString(_cursorIndexOfSubChannelId);
                String _tmpSubChannelName = _cursor.isNull(_cursorIndexOfSubChannelName) ? null : _cursor.getString(_cursorIndexOfSubChannelName);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfSubChannelUpdatedAt) ? null : _cursor.getString(_cursorIndexOfSubChannelUpdatedAt);
                DateTime _tmpSubChannelUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                String _tmpCreatorId = _cursor.isNull(_cursorIndexOfCreatorId) ? null : _cursor.getString(_cursorIndexOfCreatorId);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_2 != 0;
                int _tmpSegment = _cursor.getInt(_cursorIndexOfSegment);
                _result = new MessagePreviewEntity(_tmpMessagePreviewId, _tmpDataType, _tmpData, _tmpChannelId, _tmpSubChannelId, _tmpSubChannelName, _tmpSubChannelUpdatedAt, _tmpCreatorId, _tmpIsDeleted, _tmpSegment);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_5 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            MessagePreviewEntity messagePreviewEntity = _result;
            return messagePreviewEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

