package com.amity.socialcloud.sdk.social.data.category

import com.amity.socialcloud.sdk.common.EntityMapper
import com.amity.socialcloud.sdk.entity.social.category.CommunityCategoryEntity
import com.ekoapp.ekosdk.internal.api.dto.EkoCommunityCategoryDto
import com.ekoapp.ekosdk.internal.api.mapper.EkoCommunityCategoryMapper

internal class CategoryEntityMapper : EntityMapper<EkoCommunityCategoryDto, CommunityCategoryEntity>() {

    override fun map(list: List<EkoCommunityCategoryDto>): List<CommunityCategoryEntity> {
        return list.map { map(it) }
    }

    private fun map(dto: EkoCommunityCategoryDto) : CommunityCategoryEntity {
        return CommunityCategoryEntity().apply {
            categoryId = dto.categoryId
            name = dto.name
            avatarFileId = dto.avatarFileId
            metadata = dto.metadata
            isDeleted = dto.deleted
            setCreatedAt(dto.createdAt)
            setUpdatedAt(dto.updatedAt)
        }
    }
}