package com.ekoapp.ekosdk.internal.api.mapper

import com.ekoapp.ekosdk.internal.api.dto.EkoFollowDto
import com.ekoapp.ekosdk.internal.data.model.EkoUserFollowStatusEntity
import org.joda.time.DateTime

interface EkoFollowMapper : EkoObjectMapper<EkoFollowDto, EkoUserFollowStatusEntity> {
	companion object {
		@JvmField
        val MAPPER: EkoFollowMapper = object: EkoFollowMapper {
			override fun map(dto: EkoFollowDto): EkoUserFollowStatusEntity? {
				return EkoUserFollowStatusEntity().apply{
					id = dto.getId()
					sourceUserId = dto.from ?: ""
					targetUserId = dto.to ?: ""
					status = dto.status
					createdAt = dto.createdAt ?: DateTime.now()
					updatedAt = dto.updatedAt ?: DateTime.now()
				}
				
			}
			
		}
	}
}