package com.amity.socialcloud.sdk.model.core.invitation

import android.os.Parcelable
import com.amity.socialcloud.sdk.model.core.user.AmityUser
import com.amity.socialcloud.sdk.model.social.community.AmityCommunity
import com.ekoapp.ekosdk.ReactorObject
import com.ekoapp.ekosdk.internal.usecase.invitation.AcceptInvitationUseCase
import com.ekoapp.ekosdk.internal.usecase.invitation.CancelInvitationUseCase
import com.ekoapp.ekosdk.internal.usecase.invitation.RejectInvitationUseCase
import io.reactivex.rxjava3.core.Completable
import kotlinx.parcelize.Parcelize
import org.joda.time.DateTime

@Parcelize
data class AmityInvitation internal constructor(
    private val invitationId: String,
    private val type: AmityInvitationType,
    private val targetId: String,
    private val targetType: String,
    internal var target: Target? = null,
    private val userId: String,
    internal var user: AmityUser? = null,
    private val createdById: String,
    internal var createdBy: AmityUser? = null,
    private val status: AmityInvitationStatus,
    private val createdAt: DateTime,
    private val updatedAt: DateTime,
) : Parcelable, ReactorObject {

    sealed class Target : Parcelable  {
        @Parcelize
        data class Community(val community: AmityCommunity) : Target()
    }

    fun getInvitationId(): String {
        return invitationId
    }

    fun getType(): AmityInvitationType {
        return type
    }

    fun getTargetId(): String {
        return targetId
    }

    fun getTargetType(): String {
        return targetType
    }

    fun getUserId(): String {
        return userId
    }

    fun getUser(): AmityUser? {
        return user
    }

    fun getStatus(): AmityInvitationStatus {
        return status
    }

    fun getCreatedById(): String {
        return createdById
    }

    fun getCreatedBy(): AmityUser? {
        return createdBy
    }

    fun getCreatedAt(): DateTime {
        return createdAt
    }

    override fun updatedAt(): DateTime {
        return createdAt
    }

    override fun uniqueId(): String {
        return invitationId
    }

    fun accept(): Completable {
        return AcceptInvitationUseCase().execute(invitationId)
    }

    fun reject(): Completable {
        return RejectInvitationUseCase().execute(invitationId)
    }

    fun cancel(): Completable {
        return CancelInvitationUseCase().execute(invitationId)
    }

}