package com.amity.socialcloud.sdk.core.data.settings.network

import com.amity.socialcloud.sdk.core.data.settings.network.chat.ChatSettingsQueryPersister
import com.amity.socialcloud.sdk.core.data.settings.network.core.user.UserSettingsQueryPersister
import com.amity.socialcloud.sdk.core.data.settings.network.social.SocialSettingsQueryPersister
import com.ekoapp.ekosdk.EkoObjectRepository
import io.reactivex.rxjava3.core.Completable

internal class NetworkSettingsRepository : EkoObjectRepository() {

    fun getChatSettings(): Completable {
        return NetworkSettingsRemoteDataStore().getChatSettings()
            .flatMapCompletable {
                ChatSettingsQueryPersister().persist(it)
            }
    }

    fun getSocialSettings(): Completable {
        return NetworkSettingsRemoteDataStore().getSocialSettings()
            .flatMapCompletable {
                it.socialNetworkSetting?.let { setting ->
                    SocialSettingsQueryPersister().persist(setting)
                } ?: Completable.complete()
            }
    }

    fun getUserSettings(): Completable {
        return NetworkSettingsRemoteDataStore().getCoreUserSettings()
            .flatMapCompletable {
                UserSettingsQueryPersister().persist(it)
            }
    }

    fun validateUrls(urls: List<String>): Completable {
        return NetworkSettingsRemoteDataStore().validateUrls(urls)
    }

    fun validateTexts(texts: List<String>): Completable {
        return NetworkSettingsRemoteDataStore().validateTexts(texts)
    }

}