package com.amity.socialcloud.sdk.api.chat.message.create

import com.amity.socialcloud.sdk.model.chat.message.AmityMessage
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.google.gson.JsonObject

class AmityCustomMessageCreator private constructor(
    subChannelId: String,
    parentId: String?,
    tags: AmityTags,
    private val data: JsonObject,
    private val metadata: JsonObject?,
) : AmityMessageCreator(
    subChannelId = subChannelId,
    parentId = parentId,
    tags = tags,
    metadata = metadata,
) {

    override fun getData(): JsonObject {
        return data
    }

    override fun getDataType(): AmityMessage.DataType {
        return AmityMessage.DataType.CUSTOM
    }

    class Builder internal constructor() {
        private lateinit var subChannelId: String
        private var parentId: String? = null
        private lateinit var data: JsonObject
        private var metadata: JsonObject? = null
        private var tags: AmityTags = AmityTags()

        internal fun subChannelId(subChannelId: String): Builder {
            return apply { this.subChannelId = subChannelId }
        }

        internal fun data(data: JsonObject): Builder {
            return apply { this.data = data }
        }
        fun parentId(parentId: String?): Builder {
            return apply { this.parentId = parentId }
        }
    
        fun metadata(metadata: JsonObject): Builder {
            return apply { this.metadata = metadata }
        }

        fun tags(tags: AmityTags): Builder {
            return apply { this.tags = tags }
        }

        fun build(): AmityCustomMessageCreator {
            return AmityCustomMessageCreator(subChannelId, parentId, tags, data, metadata)
        }
    }

}