package com.ekoapp.ekosdk.internal.api.mapper

import com.ekoapp.ekosdk.internal.api.dto.EkoPollDto
import com.ekoapp.ekosdk.internal.entity.PollEntity
import org.joda.time.DateTime

internal class EkoPollMapper : EkoObjectMapper<EkoPollDto, PollEntity> {

    override fun map(dto: EkoPollDto?): PollEntity {
        return PollEntity()
            .apply {
                pollId = dto?.pollId ?: ""
                userId = dto?.userId ?: ""
                question = dto?.question ?: ""
                answers = dto?.answers ?: emptyList()
                answerType = dto?.answerType ?: ""
                status = dto?.status ?: ""
                closedAt = dto?.closedAt ?: DateTime.now()
                isDeleted = dto?.isDeleted ?: false
                isVoted = dto?.isVoted ?: false
                createdAt = dto?.createdAt
                updatedAt = dto?.updatedAt
            }
    }
}