package com.amity.socialcloud.sdk.social.data.post.pin

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.entity.social.story.StoryEntity
import com.amity.socialcloud.sdk.model.social.story.AmityStory
import com.amity.socialcloud.sdk.social.data.post.paging.GlobalPinKeyCreator
import com.amity.socialcloud.sdk.social.data.story.StorySinglePageKeyCreator
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.data.model.PinEntity
import com.ekoapp.ekosdk.internal.paging.QueryStreamPagingDao
import io.reactivex.rxjava3.core.Flowable


@Dao
internal interface GlobalPinSinglePageDao : QueryStreamPagingDao<PinEntity> {
    @RawQuery(observedEntities = [PinEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, PinEntity>

    @RawQuery(observedEntities = [PinEntity::class, AmityPagingId::class])
    fun getPinnedPostsImpl(query: SimpleSQLiteQuery): Flowable<List<PinEntity>>

    fun getPinnedPostPagingSource(): Flowable<List<PinEntity>> {
        val keyCreator = GlobalPinKeyCreator()
        val query =  generateQueryStreamSQL(
            tableName = "pin",
            primaryKeyColumnName = "pinId",
            queryStreamKeyCreator = keyCreator,
            nonce = AmityNonce.GLOBAL_PINNED_POST_LIST,
            order = AmityPagingDao.Order.ASC
        )
        return getPinnedPostsImpl(query)
    }
}