/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.community;

import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import co.amity.rxbridge.FlowableKt;
import com.amity.socialcloud.sdk.api.social.community.query.AmityCommunitySortOption;
import com.amity.socialcloud.sdk.common.AmityObjectRepository;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.infra.retrofit.request.QueryOptionsRequestParams;
import com.amity.socialcloud.sdk.model.core.tag.AmityTags;
import com.amity.socialcloud.sdk.model.social.community.AmityCommunity;
import com.amity.socialcloud.sdk.model.social.community.AmityCommunityFilter;
import com.amity.socialcloud.sdk.model.social.community.AmityCommunityMembershipStatusFilter;
import com.amity.socialcloud.sdk.model.social.community.AmityCommunityStorySettings;
import com.amity.socialcloud.sdk.model.social.feed.AmityFeedType;
import com.amity.socialcloud.sdk.social.data.community.CommunityLocalDataStore;
import com.amity.socialcloud.sdk.social.data.community.CommunityModelMapper;
import com.amity.socialcloud.sdk.social.data.community.CommunityRemoteDataStore;
import com.amity.socialcloud.sdk.social.data.community.CommunityRepository;
import com.amity.socialcloud.sdk.social.data.community.paging.CommunityQueryMediator;
import com.amity.socialcloud.sdk.social.data.community.paging.CommunitySearchMediator;
import com.amity.socialcloud.sdk.social.data.community.paging.CommunitySemanticSearchMediator;
import com.ekoapp.ekosdk.internal.api.dto.EkoDeletionDto;
import com.ekoapp.ekosdk.internal.entity.CommunityEntity;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagerCreator;
import com.ekoapp.ekosdk.internal.paging.QueryStreamPagerCreator;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.functions.Function;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u007f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\bJ\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\bH\u0016J\u0014\u0010\u001c\u001a\u00020\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u000bJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0019\u001a\u00020\bJ \u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000b0 2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u000bJA\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\"0 2\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010*J\b\u0010+\u001a\u00020,H\u0002J;\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00030 2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020&2\b\u0010)\u001a\u0004\u0018\u00010\r2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020,\u00a2\u0006\u0002\u00101J\u001c\u00102\u001a\b\u0012\u0004\u0012\u00020,0 2\u0006\u00103\u001a\u00020\b2\u0006\u00104\u001a\u000205J\u0012\u00106\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000b0 J\u0012\u00107\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000b0 J\u000e\u00108\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\bJ\u000e\u00109\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\bJ\u0014\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030;H\u0016J\u0016\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00020 2\u0006\u0010\u001b\u001a\u00020\bH\u0016J\u0012\u0010=\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001b\u001a\u00020\bH\u0016J>\u0010>\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\"0 2\u0006\u0010?\u001a\u00020\b2\b\u0010%\u001a\u0004\u0018\u00010@2\b\u0010A\u001a\u0004\u0018\u00010B2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u000bJA\u0010C\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\"0 2\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010*Jy\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010\u0019\u001a\u00020\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010E\u00a8\u0006F"}, d2={"Lcom/amity/socialcloud/sdk/social/data/community/CommunityRepository;", "Lcom/amity/socialcloud/sdk/common/AmityObjectRepository;", "Lcom/ekoapp/ekosdk/internal/entity/CommunityEntity;", "Lcom/amity/socialcloud/sdk/model/social/community/AmityCommunity;", "()V", "createCommunity", "Lio/reactivex/rxjava3/core/Single;", "displayName", "", "description", "categoryIds", "", "isPublic", "", "metadata", "Lcom/google/gson/JsonObject;", "userIds", "avatarFileId", "needApprovalOnPostCreation", "onlyAdminCanPost", "storySettings", "Lcom/amity/socialcloud/sdk/model/social/community/AmityCommunityStorySettings;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/Boolean;Lcom/google/gson/JsonObject;Ljava/util/List;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;Lcom/amity/socialcloud/sdk/model/social/community/AmityCommunityStorySettings;)Lio/reactivex/rxjava3/core/Single;", "deleteCommunity", "Lio/reactivex/rxjava3/core/Completable;", "communityId", "fetchAndSave", "objectId", "fetchCommunityByIds", "communityIds", "getCommunityById", "getCommunityByIds", "Lio/reactivex/rxjava3/core/Flowable;", "getCommunityPagingData", "Landroidx/paging/PagingData;", "keyword", "categoryId", "filter", "Lcom/amity/socialcloud/sdk/model/social/community/AmityCommunityFilter;", "sortBy", "Lcom/amity/socialcloud/sdk/api/social/community/query/AmityCommunitySortOption;", "isDeleted", "(Ljava/lang/String;Ljava/lang/String;Lcom/amity/socialcloud/sdk/model/social/community/AmityCommunityFilter;Lcom/amity/socialcloud/sdk/api/social/community/query/AmityCommunitySortOption;Ljava/lang/Boolean;)Lio/reactivex/rxjava3/core/Flowable;", "getDefaultPageSize", "", "getLatestCommunity", "dynamicQueryStreamKeyCreator", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "nonce", "(Ljava/lang/String;Lcom/amity/socialcloud/sdk/model/social/community/AmityCommunityFilter;Ljava/lang/Boolean;Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;I)Lio/reactivex/rxjava3/core/Flowable;", "getPostCount", "targetId", "feedType", "Lcom/amity/socialcloud/sdk/model/social/feed/AmityFeedType;", "getRecommendedCommunities", "getTrendingCommunities", "joinCommunity", "leaveCommunity", "mapper", "Lcom/amity/socialcloud/sdk/common/ModelMapper;", "observeFromCache", "queryFromCache", "searchCommunities", "query", "Lcom/amity/socialcloud/sdk/model/social/community/AmityCommunityMembershipStatusFilter;", "tags", "Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;", "searchCommunityPagingData", "updateCommunity", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/Boolean;Lcom/google/gson/JsonObject;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;Lcom/amity/socialcloud/sdk/model/social/community/AmityCommunityStorySettings;)Lio/reactivex/rxjava3/core/Single;", "amity-sdk_release"})
public final class CommunityRepository
extends AmityObjectRepository<CommunityEntity, AmityCommunity> {
    @Override
    @NotNull
    public Completable fetchAndSave(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        Completable completable = new CommunityRemoteDataStore().getCommunity(objectId).flatMapCompletable((Function)fetchAndSave.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"CommunityRemoteDataStore\u2026persist(it)\n            }");
        return completable;
    }

    @Override
    @Nullable
    public CommunityEntity queryFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new CommunityLocalDataStore().getCommunityById(objectId);
    }

    @Override
    @NotNull
    public ModelMapper<CommunityEntity, AmityCommunity> mapper() {
        return new CommunityModelMapper();
    }

    @Override
    @NotNull
    public Flowable<CommunityEntity> observeFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new CommunityLocalDataStore().observeCommunity(objectId);
    }

    private final int getDefaultPageSize() {
        return 20;
    }

    @NotNull
    public final Flowable<PagingData<AmityCommunity>> getCommunityPagingData(@NotNull String keyword, @NotNull String categoryId, @NotNull AmityCommunityFilter filter, @NotNull AmityCommunitySortOption sortBy, @Nullable Boolean isDeleted) {
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        Intrinsics.checkNotNullParameter((Object)categoryId, (String)"categoryId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)((Object)sortBy), (String)"sortBy");
        DynamicQueryStreamPagerCreator pagerCreator2 = new DynamicQueryStreamPagerCreator(new PagingConfig(15, 0, true, 0, 0, 0, 58, null), null, new CommunityQueryMediator(keyword, categoryId, filter, sortBy, isDeleted), (Function0)new Function0<PagingSource<Integer, CommunityEntity>>(keyword, categoryId, filter, sortBy, isDeleted){
            final /* synthetic */ String $keyword;
            final /* synthetic */ String $categoryId;
            final /* synthetic */ AmityCommunityFilter $filter;
            final /* synthetic */ AmityCommunitySortOption $sortBy;
            final /* synthetic */ Boolean $isDeleted;
            {
                this.$keyword = $keyword;
                this.$categoryId = $categoryId;
                this.$filter = $filter;
                this.$sortBy = $sortBy;
                this.$isDeleted = $isDeleted;
                super(0);
            }

            @NotNull
            public final PagingSource<Integer, CommunityEntity> invoke() {
                return new CommunityLocalDataStore().getCommunityPagingSource(this.$keyword, this.$categoryId, this.$filter, this.$sortBy, this.$isDeleted);
            }
        }, (ModelMapper)new CommunityModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator2.create());
    }

    @NotNull
    public final Flowable<PagingData<AmityCommunity>> searchCommunityPagingData(@NotNull String keyword, @NotNull String categoryId, @NotNull AmityCommunityFilter filter, @NotNull AmityCommunitySortOption sortBy, @Nullable Boolean isDeleted) {
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        Intrinsics.checkNotNullParameter((Object)categoryId, (String)"categoryId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)((Object)sortBy), (String)"sortBy");
        QueryStreamPagerCreator pagerCreator2 = new QueryStreamPagerCreator(new PagingConfig(20, 0, true, 0, 0, 0, 58, null), null, new CommunitySearchMediator(keyword, categoryId, filter, sortBy, isDeleted), (Function0)new Function0<PagingSource<Integer, CommunityEntity>>(keyword, categoryId, filter, sortBy, isDeleted){
            final /* synthetic */ String $keyword;
            final /* synthetic */ String $categoryId;
            final /* synthetic */ AmityCommunityFilter $filter;
            final /* synthetic */ AmityCommunitySortOption $sortBy;
            final /* synthetic */ Boolean $isDeleted;
            {
                this.$keyword = $keyword;
                this.$categoryId = $categoryId;
                this.$filter = $filter;
                this.$sortBy = $sortBy;
                this.$isDeleted = $isDeleted;
                super(0);
            }

            @NotNull
            public final PagingSource<Integer, CommunityEntity> invoke() {
                return new CommunityLocalDataStore().searchCommunityPagingSource(this.$keyword, this.$categoryId, this.$filter, this.$sortBy, this.$isDeleted);
            }
        }, new CommunityModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator2.create());
    }

    @NotNull
    public final Flowable<List<AmityCommunity>> getRecommendedCommunities() {
        Flowable flowable = new CommunityRemoteDataStore().getRecommendedCommunities(new QueryOptionsRequestParams(20, null, 2, null)).flatMap((Function)getRecommendedCommunities.1.INSTANCE).flatMapPublisher((Function)getRecommendedCommunities.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"CommunityRemoteDataStore\u2026          }\n            }");
        return flowable;
    }

    @NotNull
    public final Flowable<List<AmityCommunity>> getTrendingCommunities() {
        Flowable flowable = new CommunityRemoteDataStore().getTrendingCommunities(new QueryOptionsRequestParams(20, null, 2, null)).flatMap((Function)getTrendingCommunities.1.INSTANCE).flatMapPublisher((Function)getTrendingCommunities.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"CommunityRemoteDataStore\u2026          }\n            }");
        return flowable;
    }

    @NotNull
    public final Single<AmityCommunity> createCommunity(@NotNull String displayName, @Nullable String description, @Nullable List<String> categoryIds, @Nullable Boolean isPublic, @Nullable JsonObject metadata, @Nullable List<String> userIds, @Nullable String avatarFileId, @Nullable Boolean needApprovalOnPostCreation, @Nullable Boolean onlyAdminCanPost, @Nullable AmityCommunityStorySettings storySettings) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Single single = new CommunityRemoteDataStore().createCommunity(displayName, description, categoryIds, isPublic, metadata, userIds, avatarFileId, needApprovalOnPostCreation, onlyAdminCanPost, storySettings).flatMap((Function)createCommunity.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"CommunityRemoteDataStore\u2026              )\n        }");
        return single;
    }

    @NotNull
    public final Single<AmityCommunity> updateCommunity(@NotNull String communityId, @Nullable String displayName, @Nullable String description, @Nullable List<String> categoryIds, @Nullable Boolean isPublic, @Nullable JsonObject metadata, @Nullable String avatarFileId, @Nullable Boolean needApprovalOnPostCreation, @Nullable Boolean onlyAdminCanPost, @Nullable AmityCommunityStorySettings storySettings) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Single single = new CommunityRemoteDataStore().updateCommunity(communityId, displayName, description, categoryIds, isPublic, metadata, avatarFileId, needApprovalOnPostCreation, onlyAdminCanPost, storySettings).flatMap((Function)updateCommunity.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"CommunityRemoteDataStore\u2026             ))\n        }");
        return single;
    }

    @Nullable
    public final AmityCommunity getCommunityById(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        CommunityEntity community = new CommunityLocalDataStore().getCommunityById(communityId);
        return community == null ? null : new CommunityModelMapper().map(community);
    }

    @NotNull
    public final Completable joinCommunity(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Completable completable = new CommunityRemoteDataStore().joinCommunity(communityId).flatMapCompletable((Function)joinCommunity.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"CommunityRemoteDataStore\u2026persist(it)\n            }");
        return completable;
    }

    @NotNull
    public final Completable leaveCommunity(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Completable completable = new CommunityRemoteDataStore().leaveCommunity(communityId).flatMapCompletable((Function)leaveCommunity.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"CommunityRemoteDataStore\u2026Persister().persist(it) }");
        return completable;
    }

    @NotNull
    public final Completable deleteCommunity(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Completable completable = new CommunityRemoteDataStore().deleteCommunity(communityId).flatMapCompletable(new Function(communityId){
            final /* synthetic */ String $communityId;
            {
                this.$communityId = $communityId;
            }

            @NotNull
            public final CompletableSource apply(@NotNull EkoDeletionDto it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.isSuccess() ? (CompletableSource)new CommunityLocalDataStore().deleteCommunity(this.$communityId) : (CompletableSource)Completable.complete();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"communityId: String): Co\u2026          }\n            }");
        return completable;
    }

    @NotNull
    public final Flowable<AmityCommunity> getLatestCommunity(@NotNull String categoryId, @NotNull AmityCommunityFilter filter, @Nullable Boolean isDeleted, @NotNull DynamicQueryStreamKeyCreator dynamicQueryStreamKeyCreator, int nonce) {
        Intrinsics.checkNotNullParameter((Object)categoryId, (String)"categoryId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)dynamicQueryStreamKeyCreator, (String)"dynamicQueryStreamKeyCreator");
        Flowable flowable = new CommunityLocalDataStore().getLatestCommunity(categoryId, filter, isDeleted, dynamicQueryStreamKeyCreator, nonce).map((Function)getLatestCommunity.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"CommunityLocalDataStore(\u2026apper().map(it)\n        }");
        return flowable;
    }

    @NotNull
    public final Flowable<PagingData<AmityCommunity>> searchCommunities(@NotNull String query, @Nullable AmityCommunityMembershipStatusFilter filter, @Nullable AmityTags tags, @Nullable List<String> categoryIds) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        int n = this.getDefaultPageSize();
        int n2 = this.getDefaultPageSize() / 2;
        DynamicQueryStreamPagerCreator pagerCreator2 = new DynamicQueryStreamPagerCreator(new PagingConfig(n, 0, true, n2, 0, 0, 48, null), null, new CommunitySemanticSearchMediator(query, filter, tags, categoryIds), (Function0)new Function0<PagingSource<Integer, CommunityEntity>>(query, filter, tags, categoryIds){
            final /* synthetic */ String $query;
            final /* synthetic */ AmityCommunityMembershipStatusFilter $filter;
            final /* synthetic */ AmityTags $tags;
            final /* synthetic */ List<String> $categoryIds;
            {
                this.$query = $query;
                this.$filter = $filter;
                this.$tags = $tags;
                this.$categoryIds = $categoryIds;
                super(0);
            }

            @NotNull
            public final PagingSource<Integer, CommunityEntity> invoke() {
                return new CommunityLocalDataStore().getSearchCommunitiesPagingSource(this.$query, this.$filter, this.$tags, this.$categoryIds);
            }
        }, (ModelMapper)new CommunityModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator2.create());
    }

    @NotNull
    public final Flowable<Integer> getPostCount(@NotNull String targetId, @NotNull AmityFeedType feedType) {
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)((Object)feedType), (String)"feedType");
        return new CommunityLocalDataStore().getPostCount(targetId, feedType);
    }

    @NotNull
    public final Completable fetchCommunityByIds(@NotNull List<String> communityIds) {
        Completable completable;
        Intrinsics.checkNotNullParameter(communityIds, (String)"communityIds");
        if (communityIds.isEmpty()) {
            Completable completable2 = Completable.complete();
            completable = completable2;
            Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"{\n             Completable.complete()\n        }");
        } else {
            Completable completable3 = new CommunityRemoteDataStore().getCommunityByIds(communityIds).flatMapCompletable((Function)fetchCommunityByIds.1.INSTANCE);
            completable = completable3;
            Intrinsics.checkNotNullExpressionValue((Object)completable3, (String)"{\n            CommunityR\u2026              }\n        }");
        }
        return completable;
    }

    @NotNull
    public final Flowable<List<AmityCommunity>> getCommunityByIds(@NotNull List<String> communityIds) {
        Intrinsics.checkNotNullParameter(communityIds, (String)"communityIds");
        Flowable flowable = new CommunityRemoteDataStore().getCommunityByIds(communityIds).flatMap((Function)getCommunityByIds.1.INSTANCE).flatMapPublisher((Function)getCommunityByIds.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"CommunityRemoteDataStore\u2026      }\n                }");
        return flowable;
    }
}

