package com.ekoapp.ekosdk;

import android.util.Base64;
import android.util.LruCache;

import com.amity.socialcloud.sdk.core.data.session.SessionLocalDataStore;
import com.ekoapp.ekosdk.internal.api.hash.EkoBloomFilter;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;

import org.joda.time.DateTime;

public class EkoFlag {

    private String hash;
    @SerializedName("bits")
    private int bitSize;
    @SerializedName("hashes")
    private int hashSize;

    private static final long EXPIRE_TIME = 1000;

    private static final LruCache<String, Long> timeMapHttp = new LruCache<String, Long>(100) {
        @Override
        protected Long create(String commentId) {
            return 0L;
        }
    };

    public String getHash() {
        return hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public int getBitSize() {
        return bitSize;
    }

    public void setBitSize(int bitSize) {
        this.bitSize = bitSize;
    }

    public int getHashSize() {
        return hashSize;
    }

    public void setHashSize(int hashSize) {
        this.hashSize = hashSize;
    }

    public boolean mightFlaggedByMe() {
        return new EkoBloomFilter.Builder(Base64.decode(hash, Base64.DEFAULT),
                bitSize,
                hashSize)
                .build()
                .mightContains(new SessionLocalDataStore().getActiveUserId());
    }

    //  `id` can be commentId, messageId, postId or userId
    public boolean expired(String id) {
        long now = DateTime.now().getMillis();
        long lastHttpRequestTime = timeMapHttp.get(id);
        if (lastHttpRequestTime > 0L) {
            boolean expired = (now - lastHttpRequestTime) > EXPIRE_TIME;
            if (expired) {
                timeMapHttp.put(id, now);
            }
            return expired;
        } else {
            timeMapHttp.put(id, now);
            return true;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) return false;
        if (obj == this) return true;
        if (obj.getClass() != getClass()) return false;
        EkoFlag other = (EkoFlag) obj;
        return Objects.equal(hash, other.hash)
                && Objects.equal(bitSize, other.bitSize)
                && Objects.equal(hashSize, other.hashSize);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(
                hash,
                bitSize,
                hashSize
        );
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("hash", hash)
                .add("bitSize", bitSize)
                .add("hashSize", hashSize)
                .toString();
    }


}
