package com.amity.socialcloud.sdk.api.social

import com.amity.socialcloud.sdk.api.social.comment.AmityCommentRepository
import com.amity.socialcloud.sdk.api.social.community.AmityCommunityRepository
import com.amity.socialcloud.sdk.api.social.poll.AmityPollRepository
import com.amity.socialcloud.sdk.api.social.post.AmityFeedRepository
import com.amity.socialcloud.sdk.api.social.post.AmityPostRepository
import com.amity.socialcloud.sdk.api.social.story.AmityStoryRepository
import com.amity.socialcloud.sdk.model.chat.settings.AmitySocialSettings
import com.ekoapp.ekosdk.internal.usecase.user.GetSocialSettingsUseCase
import io.reactivex.rxjava3.core.Flowable


object AmitySocialClient {

    /**
     * Instantiates an AmityFeedRepository.
     * @return new instance of AmityFeedRepository.
     */
    fun newFeedRepository(): AmityFeedRepository {
        return AmityFeedRepository()
    }

    /**
     * Instantiates an AmityCommunityRepository.
     * @return new instance of AmityCommunityRepository.
     */
    fun newCommunityRepository(): AmityCommunityRepository {
        return AmityCommunityRepository()
    }

    /**
     * Instantiates an AmityCommentRepository.
     * @return new instance of AmityCommentRepository.
     */
    fun newCommentRepository(): AmityCommentRepository {
        return AmityCommentRepository()
    }

    /**
     * Instantiates an AmityPostRepository.
     * @return new instance of AmityPostRepository.
     */
    fun newPostRepository(): AmityPostRepository {
        return AmityPostRepository()
    }

    /**
     * Instantiates an AmityPollRepository.
     * @return new instance of AmityPollRepository.
     */
    fun newPollRepository(): AmityPollRepository {
        return AmityPollRepository()
    }

    fun newStoryRepository(): AmityStoryRepository {
        return AmityStoryRepository()
    }

    fun getSettings(): Flowable<AmitySocialSettings> {
        return GetSocialSettingsUseCase().execute()
    }
}