package com.ekoapp.ekosdk.internal.api.mapper

import com.amity.socialcloud.sdk.model.core.error.AmityError
import com.amity.socialcloud.sdk.model.core.error.AmityException
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.ekoapp.ekosdk.EkoCategoryIds
import com.ekoapp.ekosdk.internal.api.dto.EkoCommunityDto
import com.ekoapp.ekosdk.internal.entity.CommunityEntity

interface EkoCommunityMapper : EkoObjectMapper<EkoCommunityDto, CommunityEntity> {
	override fun update(objectOnDisk: CommunityEntity, objectToSave: CommunityEntity): CommunityEntity {
		return if (objectToSave.updatedAt.isAfter(objectOnDisk.updatedAt)
				|| objectToSave.updatedAt.isEqual(objectOnDisk.updatedAt)) {
			objectToSave
		} else objectOnDisk
	}
	
	companion object {
		val MAPPER: EkoCommunityMapper = object: EkoCommunityMapper {
			override fun map(dto: EkoCommunityDto): CommunityEntity {
				if (dto.communityId != null && !dto.communityId!!.isEmpty()) {
					val community = CommunityEntity()
					community.communityId = dto.communityId!!
					community.channelId = dto.channelId
					community.userId = dto.userId
					community.displayName = dto.displayName
					community.description = dto.description
					community.avatarFileId = dto.avatarFileId
					community.isOfficial = dto.isOfficial
					community.isPublic = dto.isPublic
					community.onlyAdminCanPost = dto.onlyAdminCanPost
					community.setTags((if (dto.tags != null) dto.tags else AmityTags())!!)
					community.metadata = dto.metadata
					community.postsCount = dto.postsCount
					community.membersCount = dto.membersCount
					community.isDeleted = dto.isDeleted
					community.categoryIds = (if (dto.categoryIds != null) dto.categoryIds else EkoCategoryIds())!!
					community.needApprovalOnPostCreation = dto.needApprovalOnPostCreation
					community.editedAt = dto.editedAt
					community.createdAt = dto.createdAt
					community.updatedAt = dto.updatedAt
					if (dto.path != null) {
						community.path = dto.path!!
					}
					if (dto.isJoined != null) {
						community.isJoined = dto.isJoined
					} else {
						community.isJoined = true
					}
					return community
				} else {
					return throw AmityException.create("Fail to persist community", null, AmityError.UNKNOWN)
				}
			}
		}
	}
}