package com.amity.socialcloud.sdk.social.data.community

import com.ekoapp.ekosdk.internal.api.dto.CommunityListQueryDto
import com.ekoapp.ekosdk.internal.api.dto.EkoDeletionDto
import com.ekoapp.ekosdk.internal.api.dto.EkoPostQueryDto
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityCreateRequest
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityUpdateRequest

import io.reactivex.rxjava3.core.Single
import retrofit2.http.*

interface CommunityApi {

    @GET("api/v3/communities/{communityId}")
    fun getCommunity(@Path("communityId") communityId: String): Single<CommunityListQueryDto>

    @GET("api/v3/communities/recommended")
    fun getRecommendedCommunities(
        @Query("options[limit]", encoded = true) limit: Int? = null,
        @Query(value = "options[token]", encoded = true) token: String? = null
    ): Single<CommunityListQueryDto>

    @GET("api/v3/communities/top-trending")
    fun getTrendingCommunities(
        @Query("options[limit]", encoded = true) limit: Int? = null,
        @Query(value = "options[token]", encoded = true) token: String? = null
    ): Single<CommunityListQueryDto>

    @GET("api/v3/communities")
    fun queryCommunities(
        @Query("keyword") keyword: String? = null,
        @Query("categoryId") categoryId: String? = null,
        @Query("filter") filter: String? = null,
        @Query("sortBy") sortBy: String? = null,
        @Query("isDeleted") isDeleted: Boolean? = null,
        @Query("options[limit]", encoded = true) limit: Int? = null,
        @Query(value = "options[token]", encoded = true) token: String? = null
    ): Single<CommunityListQueryDto>

    @POST("api/v3/communities")
    fun createCommunity(@Body request: CommunityCreateRequest): Single<CommunityListQueryDto>

    @PUT("api/v3/communities/{communityId}")
    fun updateCommunity(@Path("communityId") communityId: String, @Body request: CommunityUpdateRequest): Single<CommunityListQueryDto>

    @DELETE("api/v3/communities/{communityId}")
    fun deleteCommunity(@Path("communityId") communityId: String): Single<EkoDeletionDto>

    @POST("api/v3/communities/{communityId}/join")
    fun joinCommunity(@Path("communityId") communityId: String): Single<CommunityListQueryDto>

    @DELETE("api/v3/communities/{communityId}/leave")
    fun leaveCommunity(@Path("communityId") communityId: String): Single<CommunityListQueryDto>

    @GET("api/v1/semantic-search/communities")
    fun searchCommunities(
        @Query("query") query: String,
        @Query("filter") filter: String? = null,
        @Query("categoryIds[]", encoded = true) categoryIds: List<String>?,
        @Query("tags[]", encoded = true) tags: List<String>?,
        @Query("options[limit]", encoded = true) limit: Int? = null,
        @Query("options[token]", encoded = true) token: String? = null
    ): Single<CommunityListQueryDto>

    @GET("aapi/v3/communities/list")
    fun getCommunityByIds(@Query("communityIds[]") communityId: List<String>): Single<CommunityListQueryDto>
}