package com.amity.socialcloud.sdk.core.data.pin.paging

import com.amity.socialcloud.sdk.core.data.pin.PinRemoteDataStore
import com.amity.socialcloud.sdk.core.data.pin.PinnedPostQueryPersister
import com.amity.socialcloud.sdk.social.data.post.paging.GlobalPinKeyCreator
import com.ekoapp.ekosdk.internal.api.dto.PinnedPostQueryDto
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.data.model.PinEntity
import com.ekoapp.ekosdk.internal.mediator.SinglePageMediator
import com.ekoapp.ekosdk.internal.token.DynamicQueryStreamQueryToken
import com.ekoapp.ekosdk.internal.token.QueryStreamQueryToken
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single


class GlobalPinnedPostMediator :
    SinglePageMediator<PinEntity, PinnedPostQueryDto>(
        dynamicQueryStreamKeyCreator = GlobalPinKeyCreator(),
        nonce = AmityNonce.GLOBAL_PINNED_POST_LIST
    ) {

    override fun persistResponse(dto: PinnedPostQueryDto): Completable {
        return PinnedPostQueryPersister().persist(dto)
    }

    override fun getRequest(): Single<PinnedPostQueryDto> {
        return PinRemoteDataStore().queryGlobalPinnedPosts()
    }

    override fun convertResponseToQueryToken(dto: PinnedPostQueryDto): QueryStreamQueryToken {
        val pinIds = mutableListOf<String>()
        dto.pinTargets.firstOrNull()?.let { target ->
            dto.pins.forEach { pinDto ->
                pinIds.add(pinDto.getId(target))
            }
        }
        return DynamicQueryStreamQueryToken(
            dynamicQueryStreamKeyCreator = dynamicQueryStreamKeyCreator,
            next = null,
            previous = null,
            primaryKeys = pinIds
        )
    }

}