package com.amity.socialcloud.sdk.chat.data.subchannel

import com.ekoapp.ekosdk.internal.api.dto.SubChannelListDto
import com.ekoapp.ekosdk.internal.api.dto.SubChannelQueryDto
import com.ekoapp.ekosdk.internal.api.socket.request.SubChannelCreateRequest
import com.ekoapp.ekosdk.internal.api.socket.request.SubChannelUpdateRequest
import io.reactivex.rxjava3.core.Single
import retrofit2.http.*

interface SubChannelApi {

    @POST("api/v5/message-feeds")
    fun createSubChannel(
        @Body request: SubChannelCreateRequest
    ): Single<SubChannelListDto>

    @PUT("api/v5/message-feeds/{subChannelId}")
    fun updateSubChannel(
        @Path("subChannelId") subChannelId: String,
        @Body request: SubChannelUpdateRequest
    ): Single<SubChannelListDto>

    @DELETE("api/v5/message-feeds/{subChannelId}")
    fun deleteSubChannel(
        @Path("subChannelId") subChannelId: String,
        @Query("permanent") permanent: Boolean? = false
    ): Single<SubChannelListDto>

    @GET("api/v5/message-feeds/{subChannelId}")
    fun getSubChannel(
        @Path("subChannelId") subChannelId: String
    ): Single<SubChannelListDto>

    @GET("api/v5/message-feeds/channel/{channelId}")
    fun querySubChannels(
        @Path("channelId") channelId: String,
        @Query("isDeleted") isDeleted: Boolean? = false,
        @Query("excludeDefaultMessageFeed") excludeDefaultMessageFeed: Boolean? = null,
        @Query("options[limit]", encoded = true) limit: Int? = null,
        @Query("options[token]", encoded = true) token: String? = null
    ): Single<SubChannelQueryDto>
}