package com.ekoapp.ekosdk.internal;

import androidx.room.Entity
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionMap
import com.amity.socialcloud.sdk.model.social.feed.AmityFeedType
import com.ekoapp.ekosdk.EkoObject
import com.ekoapp.ekosdk.internal.api.dto.EkoMentioneesDto
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import com.google.gson.JsonObject
import org.amity.types.ObjectId
import org.joda.time.DateTime

@Entity(tableName = "post", primaryKeys = ["postId"])
open class PostEntity : EkoObject() {

    var postId: String = ObjectId.get().toHexString()
    var mid: String = ""
    var path: String = ""
    var parentPostId: String? = null
    var postedUserId: String = ""
    var sharedUserId: String? = null
    var metadata: JsonObject? = null
    var sharedCount = 0
    var reactions: AmityReactionMap = AmityReactionMap()
    var reactionCount = 0
    var commentCount = 0
    var flagCount = 0
    var editedAt: DateTime? = null
    var isDeleted: Boolean = false
    var targetType: String = ""
    var targetId: String = ""
    var postDataType: String = ""
    var data: JsonObject? = null
    var childPostIds: List<String> = emptyList()
    var feedType: String = AmityFeedType.PUBLISHED.apiKey
    var mentionees: List<EkoMentioneesDto> = emptyList()
    var impression = 0
    var reach = 0

    override fun getId(): String {
        return postId
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other is PostEntity
                && Objects.equal(postId, other.postId)
                && Objects.equal(mid, other.mid)
                && Objects.equal(path, other.path)
                && Objects.equal(parentPostId, other.parentPostId)
                && Objects.equal(postedUserId, other.postedUserId)
                && Objects.equal(sharedUserId, other.sharedUserId)
                && Objects.equal(metadata, other.metadata)
                && Objects.equal(sharedCount, other.sharedCount)
                && Objects.equal(reactions, other.reactions)
                && Objects.equal(reactionCount, other.reactionCount)
                && Objects.equal(commentCount, other.commentCount)
                && Objects.equal(flagCount, other.flagCount)
                && Objects.equal(editedAt, other.editedAt)
                && Objects.equal(isDeleted, other.isDeleted)
                && Objects.equal(targetType, other.targetType)
                && Objects.equal(targetId, other.targetId)
                && Objects.equal(data, other.data)
                && Objects.equal(childPostIds, other.childPostIds)
                && Objects.equal(feedType, other.feedType)
                && Objects.equal(mentionees, other.mentionees)
                && Objects.equal(impression, other.impression)
                && Objects.equal(reach, other.reach))
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
            postId,
            mid,
            path,
            parentPostId,
            postedUserId,
            sharedUserId,
            metadata,
            sharedCount,
            reactions,
            reactionCount,
            commentCount,
            flagCount,
            editedAt,
            isDeleted,
            targetType,
            targetId,
            data,
            childPostIds,
            feedType,
            mentionees,
            impression,
            reach
        )
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("postId", postId)
            add("mid", mid)
            add("path", path)
            add("parentPostId", parentPostId)
            add("postedUserId", postedUserId)
            add("sharedUserId", sharedUserId)
            add("metadata", metadata)
            add("sharedCount", sharedCount)
            add("reactions", reactions)
            add("reactionCount", reactionCount)
            add("commentCount", commentCount)
            add("flagCount", flagCount)
            add("editedAt", editedAt)
            add("isDeleted", isDeleted)
            add("targetType", targetType)
            add("targetId", targetId)
            add("data", data)
            add("childPostIds", childPostIds)
            add("feedType", feedType)
            add("mentionees", mentionees)
            add("impression", impression)
            add("reach", reach)
        }
        return super.internalToString(toStringHelper)
    }

}