package com.amity.socialcloud.sdk.model.core.follow

enum class AmityFollowStatus(val apiKey: String) {
    PENDING("pending"),
    ACCEPTED("accepted"),
    BLOCKED("blocked"),
    NONE("none");

    companion object {
        fun enumOf(value: String?): AmityFollowStatus {
            return values().find { it.apiKey == value } ?: NONE
        }
    }
}