package com.amity.socialcloud.sdk.api.core.user.search

import androidx.paging.PagingData
import com.amity.socialcloud.sdk.model.core.user.AmityUser
import com.ekoapp.ekosdk.internal.usecase.user.GetUserPagingDataUseCase
import io.reactivex.rxjava3.core.Flowable


class AmityUserSearch private constructor(
    private val keyword: String?,
    private val matchType: AmityUserSearchMatchType,
    private val sortOption: AmityUserSortOption
) {

    fun query(): Flowable<PagingData<AmityUser>> {
        return GetUserPagingDataUseCase().execute(keyword = keyword, matchType = matchType, sortBy = sortOption)
    }

    class Builder internal constructor() {
        private var keyword: String? = null
        private var matchType: AmityUserSearchMatchType = AmityUserSearchMatchType.DEFAULT
        private var sortOption: AmityUserSortOption = AmityUserSortOption.DISPLAYNAME

        internal fun keyword(keyword: String): Builder {
            this.keyword = keyword
            return this
        }

        fun matchType(matchType: AmityUserSearchMatchType): Builder {
            this.matchType = matchType
            return this
        }

        fun sortBy(sortOption: AmityUserSortOption): Builder {
            this.sortOption = sortOption
            return this
        }

        fun build(): AmityUserSearch {
            return AmityUserSearch(keyword, matchType, sortOption)
        }
    }

}