package com.ekoapp.ekosdk.internal.data.converter

import androidx.room.TypeConverter
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.ekoapp.ekosdk.internal.data.converter.EkoGson.get

class EkoTagsTypeConverter {
	@TypeConverter
	fun stringToEkoTags(json: String): AmityTags {
		return get().fromJson(json, AmityTags::class.java)
	}
	
	@TypeConverter
	fun ekoTagsToString(tags: AmityTags): String {
		return get().toJson(tags)
	}
}