package com.amity.socialcloud.sdk.dto.social.story

import com.amity.socialcloud.sdk.model.social.story.AmityStoryItem
import com.google.gson.JsonObject

class CreateVideoStoryRequest(
    referenceId: String,
    targetType: String,
    targetId: String,
    fileId: String,
    storyItems: List<AmityStoryItem>,
    metadata: JsonObject?
) : CreateStoryRequest(
    referenceId = referenceId,
    targetType = targetType,
    targetId = targetId,
    dataType = "video",
    data = JsonObject().apply {
        addProperty("fileId", fileId)
    },
    metadata = metadata,
    items = storyItems.map {
        it.getPayload()
    }
)


