package com.amity.socialcloud.sdk.social.data.storytarget

import com.amity.socialcloud.sdk.common.EntityMapper
import com.amity.socialcloud.sdk.dto.social.story.StoryTargetDto
import com.amity.socialcloud.sdk.entity.social.story.StoryTargetEntity
import com.amity.socialcloud.sdk.model.social.story.AmityStoryTarget
import org.amity.types.ObjectId
import org.joda.time.DateTime


internal class StoryTargetEntityMapper : EntityMapper<StoryTargetDto, StoryTargetEntity>() {

    override fun map(list: List<StoryTargetDto>): List<StoryTargetEntity> {
        return list.map {
            map(it)
        }
    }

    private fun map(dto: StoryTargetDto) : StoryTargetEntity {
        return StoryTargetEntity().apply {
            uniqueId = AmityStoryTarget.generateUniqueId(dto.targetType ?: "unknown",  dto.targetPublicId ?: ObjectId.get().toHexString())
            targetType = dto.targetType ?: "unknown"
            targetId = dto.targetPublicId ?: ""
            lastStoryExpiresAt = dto.lastStoryExpiresAt
            lastStorySeenExpiresAt = dto.lastStorySeenExpiresAt
            hasUnseen = dto.lastStoryExpiresAt?.isAfter(DateTime.now()) ?: false && dto.lastStoryExpiresAt?.isAfter(dto.lastStorySeenExpiresAt) ?: false
            localSortingDate = dto.lastStoryExpiresAt
            updatedAt = dto.targetUpdatedAt ?: DateTime.now()
        }
    }

}
