package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.log.AmityLog
import com.amity.socialcloud.sdk.social.data.community.CommunityLocalDataStore
import com.amity.socialcloud.sdk.social.data.community.CommunityQueryPersister
import com.ekoapp.ekosdk.internal.api.dto.CommunityListDto
import io.reactivex.rxjava3.schedulers.Schedulers
import kotlin.reflect.KClass

internal abstract class CommunityEventListener : MqttEventListener<CommunityListDto>() {

    override val type: KClass<CommunityListDto>
        get() = CommunityListDto::class

    override fun processEvent(dto: CommunityListDto) {
        CommunityQueryPersister().persist(dto)
            .subscribeOn(Schedulers.io())
            .doOnError {
                AmityLog.e(it)
            }
            .subscribe()
    }

    override fun shouldProcessEvent(dto: CommunityListDto): Boolean {
        var shouldProcessEvent = false
        val communityId = dto.communities?.first()?.communityId
        communityId?.let {
            shouldProcessEvent = CommunityLocalDataStore().hasInLocal(it)
        }
        return shouldProcessEvent
    }

}