package com.amity.socialcloud.sdk.api.core.follow

import com.amity.socialcloud.sdk.api.core.AmityCoreClient
import com.amity.socialcloud.sdk.api.core.follow.query.AmityMyFollowersQuery
import com.amity.socialcloud.sdk.api.core.follow.query.AmityMyFollowingsQuery
import com.amity.socialcloud.sdk.model.core.follow.AmityMyFollowInfo
import com.ekoapp.ekosdk.internal.usecase.user.*
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable

class AmityMyUserRelationship internal constructor() {
    
    @Deprecated("Use AmityCoreClient.newUserRepository().relationship().acceptMyFollower() instead")
    fun accept(userId: String): Completable {
        return AcceptFollowUseCase().execute(userId)
    }
    
    @Deprecated("Use AmityCoreClient.newUserRepository().relationship().declineMyFollwer() instead")
    fun decline(userId: String): Completable {
        return DeclineFollowUseCase().execute(userId)
    }

    @Deprecated("Use AmityCoreClient.newUserRepository().relationship().removeMyFollower() instead")
    fun removeFollower(userId: String): Completable {
        return RemoveFollowerUseCase().execute(userId)
    }
    
    @Deprecated("Use AmityCoreClient.newUserRepository().relationship().unfollow() instead")
    fun unfollow(userId: String): Completable {
        return UnfollowUseCase().execute(userId)
    }
    
    @Deprecated("Use AmityCoreClient.newUserRepository().relationship().getMyFollowings() instead")
    fun getFollowings(): AmityMyFollowingsQuery.Builder {
        return AmityMyFollowingsQuery.Builder()
    }
    
    @Deprecated("Use AmityCoreClient.newUserRepository().relationship().getMyFollwers() instead")
    fun getFollowers(): AmityMyFollowersQuery.Builder {
        return AmityMyFollowersQuery.Builder()
    }
    
    @Deprecated("Use AmityCoreClient.newUserRepository().relationship().getMyFollowInfo() instead")
    fun getFollowInfo(): Flowable<AmityMyFollowInfo> {
        return MyFollowLiveObjectUseCase().execute(AmityCoreClient.getUserId())
    }
}