package com.amity.socialcloud.sdk.api.chat.channel.query

import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannelFilter
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.google.common.collect.Sets

class AmityCommunityChannelQuery private constructor(isDeleted: Boolean?,
                                                     filter: AmityChannelFilter,
                                                     includingTags: AmityTags,
                                                     excludingTags: AmityTags
)
    : AmityChannelQuery(isDeleted,
                Sets.newHashSet(AmityChannel.Type.COMMUNITY),
                filter,
                includingTags,
                excludingTags) {

    class Builder internal constructor() {
        private var isDeleted: Boolean? = null
        private var filter = AmityChannelFilter.ALL
        private var includingTags = AmityTags()
        private var excludingTags = AmityTags()

        fun filter(filter: AmityChannelFilter): Builder {
            return apply { this.filter = filter }
        }

        fun includingTags(includingTags: AmityTags): Builder {
            return apply { this.includingTags = includingTags }
        }

        fun excludingTags(excludingTags: AmityTags): Builder {
            return apply { this.excludingTags = excludingTags }
        }

        fun includeDeleted(includeDeleted: Boolean): Builder {
            return apply {
                this.isDeleted = if(includeDeleted) null else false
            }
        }

        fun build(): AmityCommunityChannelQuery {
            return AmityCommunityChannelQuery(isDeleted, filter, includingTags, excludingTags)
        }

    }

}