/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.api.social.comment;

import com.amity.socialcloud.sdk.api.core.ExperimentalAmityApi;
import com.amity.socialcloud.sdk.api.social.comment.create.AmityCommentCreationTarget;
import com.amity.socialcloud.sdk.api.social.comment.latest.AmityLatestCommentQueryType;
import com.amity.socialcloud.sdk.api.social.comment.query.AmityCommentQueryType;
import com.amity.socialcloud.sdk.api.social.comment.update.AmityAttachmentCommentUpdate;
import com.amity.socialcloud.sdk.model.core.flag.AmityContentFlagReason;
import com.amity.socialcloud.sdk.model.social.comment.AmityComment;
import com.amity.socialcloud.sdk.social.domain.comment.getbyids.CommentGetByIdsUseCase;
import com.ekoapp.ekosdk.internal.api.socket.request.FlagContentRequest;
import com.ekoapp.ekosdk.internal.usecase.comment.DeleteCommentUseCase;
import com.ekoapp.ekosdk.internal.usecase.comment.FlagCommentUseCase;
import com.ekoapp.ekosdk.internal.usecase.comment.ObserveSingleCommentUseCase;
import com.ekoapp.ekosdk.internal.usecase.comment.UnFlagCommentUseCase;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0007J \u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00110\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u001b"}, d2={"Lcom/amity/socialcloud/sdk/api/social/comment/AmityCommentRepository;", "", "()V", "createComment", "Lcom/amity/socialcloud/sdk/api/social/comment/create/AmityCommentCreationTarget;", "editComment", "Lcom/amity/socialcloud/sdk/api/social/comment/update/AmityAttachmentCommentUpdate$Builder;", "commentId", "", "flagComment", "Lio/reactivex/rxjava3/core/Completable;", "reason", "Lcom/amity/socialcloud/sdk/model/core/flag/AmityContentFlagReason;", "getComment", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/model/social/comment/AmityComment;", "getCommentByIds", "", "commentIds", "", "getComments", "Lcom/amity/socialcloud/sdk/api/social/comment/query/AmityCommentQueryType;", "getLatestComment", "Lcom/amity/socialcloud/sdk/api/social/comment/latest/AmityLatestCommentQueryType;", "hardDeleteComment", "softDeleteComment", "unflagComment", "amity-sdk_release"})
public final class AmityCommentRepository {
    @ExperimentalAmityApi
    @NotNull
    public final Flowable<AmityComment> getComment(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        return new ObserveSingleCommentUseCase().execute(commentId);
    }

    @NotNull
    public final Flowable<List<AmityComment>> getCommentByIds(@NotNull Set<String> commentIds) {
        Intrinsics.checkNotNullParameter(commentIds, (String)"commentIds");
        return new CommentGetByIdsUseCase().execute(commentIds);
    }

    @NotNull
    public final AmityCommentQueryType getComments() {
        return new AmityCommentQueryType();
    }

    @NotNull
    public final AmityCommentCreationTarget createComment() {
        return new AmityCommentCreationTarget(null, 1, null);
    }

    @NotNull
    public final AmityAttachmentCommentUpdate.Builder editComment(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        return new AmityAttachmentCommentUpdate.Builder(commentId);
    }

    @NotNull
    public final Completable softDeleteComment(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        return new DeleteCommentUseCase().execute(commentId, false);
    }

    @NotNull
    public final Completable hardDeleteComment(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        return new DeleteCommentUseCase().execute(commentId, true);
    }

    @NotNull
    public final AmityLatestCommentQueryType getLatestComment() {
        return new AmityLatestCommentQueryType();
    }

    @NotNull
    public final Completable flagComment(@NotNull String commentId, @NotNull AmityContentFlagReason reason) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        FlagContentRequest request = reason instanceof AmityContentFlagReason.Others ? new FlagContentRequest(reason.getReason(), ((AmityContentFlagReason.Others)reason).getDetails()) : new FlagContentRequest(reason.getReason(), null, 2, null);
        return new FlagCommentUseCase().execute(commentId, request);
    }

    @NotNull
    public final Completable unflagComment(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        return new UnFlagCommentUseCase().execute(commentId);
    }
}

