package com.ekoapp.ekosdk.internal.usecase.analytics

import com.amity.socialcloud.sdk.core.data.analytics.AnalyticsRepository
import com.amity.socialcloud.sdk.core.data.analytics.AnalyticsService
import com.amity.socialcloud.sdk.core.engine.analytics.AnalyticsEventContentType
import com.amity.socialcloud.sdk.core.engine.analytics.AnalyticsEventSyncPriority
import com.amity.socialcloud.sdk.model.social.post.AmityPost

internal class MarkPostAsViewedUseCase {
    fun execute(post: AmityPost) {
        val event = AnalyticsRepository().createAnalyticEvent(
            contentId = post.getPostId(),
            contentType = AnalyticsEventContentType.POST,
            activityType = "view",
            syncPriority = AnalyticsEventSyncPriority.LOW,
            deduplicationKey = post.getPostId() + ".view",
        )
        AnalyticsService().captureEvent(event)
    }

}