package com.amity.socialcloud.sdk.model.social.story

import android.os.Parcelable
import com.amity.socialcloud.sdk.api.core.ExperimentalAmityApi
import com.amity.socialcloud.sdk.model.social.community.AmityCommunity
import com.ekoapp.ekosdk.ReactorObject
import kotlinx.parcelize.Parcelize
import org.joda.time.DateTime

sealed class AmityStoryTarget private constructor(
    private val uniqueId: String,
    private val targetType: AmityStory.TargetType,
    private val targetId: String,
    internal val lastStoryExpiresAt: DateTime?,
    internal val lastStorySeenExpiresAt: DateTime?,
    internal var hasUnseen: Boolean = false,
    internal var localSortingDate: DateTime?,
    internal val localLastStoryExpiresAt: DateTime?,
    internal val localLastStorySeenExpiresAt: DateTime?,
    internal var syncingStoriesCount: Int = 0,
    internal var failedStoriesCount: Int = 0,
    private val updatedAt: DateTime?,
    internal var highestSeen: DateTime? = null,
) : Parcelable, ReactorObject {

    @Parcelize
    class COMMUNITY internal constructor(
        private val uniqueId: String,
        private val targetId: String,
        private val mLastStoryExpiresAt: DateTime?,
        private val mLastStorySeenExpiresAt: DateTime?,
        private val mHasUnseen: Boolean,
        private val mLocalSortingDate: DateTime?,
        private val mLocalLastStoryExpiresAt: DateTime?,
        private val mLocalLastStorySeenExpiresAt: DateTime?,
        private val updatedAt: DateTime?,
        internal var community: AmityCommunity? = null
    ) : AmityStoryTarget(
        uniqueId,
        AmityStory.TargetType.COMMUNITY,
        targetId,
        mLastStoryExpiresAt,
        mLastStorySeenExpiresAt,
        mHasUnseen,
        mLocalSortingDate,
        mLocalLastStoryExpiresAt,
        mLocalLastStorySeenExpiresAt,
        0,
        0,
        null,
        updatedAt
    ) {
        fun getCommunity(): AmityCommunity? {
            return community
        }

    }

    @Parcelize
    object UNKNOWN: AmityStoryTarget(
        "",
        AmityStory.TargetType.UNKNOWN,
        "",
        null,
        null,
        false,
        null,
        null,
        null,
        0,
        0,
        null
    )

    fun getTargetId(): String {
        return targetId
    }

    fun getTargetType(): AmityStory.TargetType {
        return targetType
    }

    fun hasUnseen(): Boolean {
        return hasUnseen
    }

    fun getSyncingStoriesCount(): Int {
        return syncingStoriesCount
    }
    fun getFailedStoriesCount(): Int {
        return failedStoriesCount
    }

    override fun updatedAt(): DateTime? {
        return updatedAt
    }

    override fun uniqueId(): String {
        return uniqueId
    }

    companion object {
        internal fun generateUniqueId(targetType: String, targetId: String): String {
            return "$targetType/$targetId"
        }
    }

}