package com.amity.socialcloud.sdk.core.domain.token

import com.amity.socialcloud.sdk.api.core.endpoint.AmityEndpoint
import com.amity.socialcloud.sdk.model.core.session.AmityUserToken
import com.amity.socialcloud.sdk.core.data.auth.TokenRepository
import io.reactivex.rxjava3.core.Single

class CreateAmityTokenUseCase {

    fun execute(
        endpoint: AmityEndpoint,
        apiKey: String,
        userId: String,
        displayName: String? = null,
        secureToken: String? = null
    ): Single<AmityUserToken> {
        return TokenRepository().createToken(
            endpoint = endpoint,
            apiKey = apiKey,
            userId = userId,
            displayName = displayName,
            secureToken = secureToken
        )
    }
}