package com.amity.socialcloud.sdk.chat.domain.channel

import com.amity.socialcloud.sdk.chat.data.channel.ChannelRepository
import com.amity.socialcloud.sdk.chat.domain.channel.ChannelComposerUseCase
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel
import com.amity.socialcloud.sdk.model.chat.channel.ChannelUpdateOption
import io.reactivex.rxjava3.core.Single

internal class UpdateChannelUseCase {

    fun execute(channelId: String,
                option: ChannelUpdateOption
    ): Single<AmityChannel> {
        return ChannelRepository().updateChannel(channelId, option)
            .map {
                ChannelComposerUseCase().execute(it)
            }
    }

}