package com.amity.socialcloud.sdk.chat.data.channel.membership.paging

import com.amity.socialcloud.sdk.api.chat.member.query.AmityChannelMembershipSortOption
import com.amity.socialcloud.sdk.model.chat.member.AmityMembershipType
import com.amity.socialcloud.sdk.model.core.role.AmityRoles
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator
import com.ekoapp.ekosdk.internal.keycreator.toSqlArray


internal class ChannelMembershipKeyCreator(
    private val channelId: String,
    private val roles: AmityRoles,
    private val memberships: List<AmityMembershipType>,
    private val isMuted: Boolean?,
    private val sortOption: AmityChannelMembershipSortOption?,
    private val isDeleted: Boolean?
) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf(
            "channelId" to channelId,
            "roles" to roles,
            "memberships" to memberships,
            "isMuted" to (isMuted?.toString() ?: "null"),
            "sortOption" to (sortOption?.apiKey ?: "null"),
            "isDeleted" to (isDeleted?.toString() ?: "null"),
        )
    }

    override fun getFilterQuery(): String {
        return getConditionStatement(channelId, roles, memberships, isMuted, isDeleted)
    }

    private fun getConditionStatement(
        channelId: String,
        roles: AmityRoles,
        memberships: List<AmityMembershipType>,
        isMuted: Boolean?,
        isDeleted: Boolean?
    ): String {
        val membershipFilter = (memberships.takeIf { it.isNotEmpty() } ?: listOf(AmityMembershipType.MEMBER, AmityMembershipType.BANNED)).map { it.apiKey }.toSqlArray()
        val membershipFilterStatement =
            "channel_membership.membership IN (${membershipFilter})"

        val isMutedFilter = when {
            isMuted == null -> ""
            isMuted -> " and channel_membership.isMuted = 1"
            else -> " and channel_membership.isMuted = 0"
        }

        val roleFilter = if (roles.get().isEmpty()) ""
        else " and channel_membership.userId IN (SELECT userId from channel_role  where channelId = '${channelId}' and roleName IN (${roles.get().toSqlArray()}))"

        val isDeletedFilter = when {
            isDeleted == null || isDeleted -> ""
            else -> " and channel_membership.userId IN (SELECT userId from user where isDeleted = 0)"
        }

        return membershipFilterStatement +
                isMutedFilter +
                roleFilter +
                isDeletedFilter
    }

}