package com.amity.socialcloud.sdk.api.social.post.review


enum class AmityReviewStatus(val apiKey: String) {
    PUBLISHED("published"),
    UNDER_REVIEW("reviewing"),
    DECLINED("declined");

    companion object {
        fun enumOf(value: String): AmityReviewStatus {
            return values().find { it.apiKey == value } ?: PUBLISHED
        }
    }
}