package com.amity.socialcloud.sdk.social.data.storytarget.singlepage

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.entity.social.story.StoryTargetEntity
import com.amity.socialcloud.sdk.model.social.story.AmityStory
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.paging.QueryStreamPagingDao
import io.reactivex.rxjava3.core.Flowable

@Dao
internal interface StoryTargetSinglePageDao : QueryStreamPagingDao<StoryTargetEntity> {

    @RawQuery(observedEntities = [StoryTargetEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, StoryTargetEntity>

    @RawQuery(observedEntities = [StoryTargetEntity::class, AmityPagingId::class])
    fun getStoryTargetByTargetsImpl(query: SimpleSQLiteQuery): Flowable<List<StoryTargetEntity>>

    fun getStoryTargetByTargets(targets: List<Pair<AmityStory.TargetType, String>>): Flowable<List<StoryTargetEntity>> {
        val keyCreator = StoryTargetsSinglePageKeyCreator(targets = targets)
        val query =  generateQueryStreamSQL(
            tableName = "storyTarget",
            primaryKeyColumnName = "uniqueId",
            queryStreamKeyCreator = keyCreator,
            nonce = AmityNonce.STORY_TARGET_LIST,
            order = AmityPagingDao.Order.ASC
        )
        return getStoryTargetByTargetsImpl(query)
    }
}