package com.amity.socialcloud.sdk.core.data.tombstone

import com.ekoapp.ekosdk.internal.TombstoneModelType
import com.ekoapp.ekosdk.internal.data.UserDatabase
import com.ekoapp.ekosdk.internal.entity.TombstoneEntity
import io.reactivex.rxjava3.core.Completable

internal class TombstoneLocalDataStore {

    fun getTombstone(objectId: String, tombstoneModelType: TombstoneModelType): TombstoneEntity? {
        return UserDatabase.get().tombstoneDao().getTombstone(objectId, tombstoneModelType.entityName)
    }

    fun saveTombstone(tombstoneEntity: TombstoneEntity): Completable {
        return Completable.fromAction {
            UserDatabase.get().tombstoneDao().save(listOf(tombstoneEntity))
        }
    }
}