/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.file;

import android.net.Uri;
import co.amity.rxupload.RxUploadService;
import com.amity.socialcloud.sdk.core.data.file.FileEntityMapper;
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore;
import com.amity.socialcloud.sdk.core.data.file.FileRemoteDataStore;
import com.amity.socialcloud.sdk.core.data.file.FileRepository;
import com.amity.socialcloud.sdk.core.data.file.RawFileModelMapper;
import com.amity.socialcloud.sdk.infra.upload.AmityAudioUploadService;
import com.amity.socialcloud.sdk.infra.upload.AmityFileUploadService;
import com.amity.socialcloud.sdk.infra.upload.AmityImageUploadService;
import com.amity.socialcloud.sdk.infra.upload.AmityVideoUploadService;
import com.amity.socialcloud.sdk.model.core.content.AmityContentFeedType;
import com.amity.socialcloud.sdk.model.core.file.AmityAudio;
import com.amity.socialcloud.sdk.model.core.file.AmityFile;
import com.amity.socialcloud.sdk.model.core.file.AmityImage;
import com.amity.socialcloud.sdk.model.core.file.AmityRawFile;
import com.amity.socialcloud.sdk.model.core.file.AmityVideo;
import com.amity.socialcloud.sdk.model.core.file.upload.AmityUploadInfo;
import com.amity.socialcloud.sdk.model.core.file.upload.AmityUploadResult;
import com.ekoapp.ekosdk.internal.EkoFileEntity;
import com.ekoapp.ekosdk.internal.api.dto.EkoFileDto;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\u0006J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\u0006J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\t\u001a\u00020\u0006J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\t\u001a\u00020\u0006J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u00182\u0006\u0010\t\u001a\u00020\u0006J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\t\u001a\u00020\u0006J\"\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u001f0\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!J\"\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u001f0\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!J\"\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u001f0\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!J*\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001f0\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!2\u0006\u0010%\u001a\u00020&\u00a8\u0006'"}, d2={"Lcom/amity/socialcloud/sdk/core/data/file/FileRepository;", "", "()V", "cancelUpload", "", "uploadId", "", "createLocalFile", "Lio/reactivex/rxjava3/core/Completable;", "fileId", "fileType", "filePath", "deleteFile", "getAudio", "Lcom/amity/socialcloud/sdk/model/core/file/AmityAudio;", "getFile", "Lcom/amity/socialcloud/sdk/model/core/file/AmityFile;", "getImage", "Lcom/amity/socialcloud/sdk/model/core/file/AmityImage;", "getImageNow", "getLocalRawFile", "Lcom/amity/socialcloud/sdk/model/core/file/AmityRawFile;", "getLocalRawFileNow", "getRawFile", "Lio/reactivex/rxjava3/core/Single;", "getUploadInfo", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/model/core/file/upload/AmityUploadInfo;", "getVideo", "Lcom/amity/socialcloud/sdk/model/core/file/AmityVideo;", "uploadAudio", "Lcom/amity/socialcloud/sdk/model/core/file/upload/AmityUploadResult;", "uri", "Landroid/net/Uri;", "uploadFile", "uploadImage", "uploadVideo", "feedType", "Lcom/amity/socialcloud/sdk/model/core/content/AmityContentFeedType;", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nFileRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileRepository.kt\ncom/amity/socialcloud/sdk/core/data/file/FileRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,152:1\n1#2:153\n*E\n"})
public final class FileRepository {
    @NotNull
    public final Single<AmityRawFile> getRawFile(@NotNull String fileId) {
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Single single = new FileLocalDataStore().getRawFile(fileId).flatMap(new Function(fileId){
            final /* synthetic */ String $fileId;
            {
                this.$fileId = $fileId;
            }

            @NotNull
            public final SingleSource<? extends EkoFileEntity> apply(@NotNull List<EkoFileEntity> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                boolean hasInCache = !((Collection)it).isEmpty();
                return (SingleSource)(hasInCache ? Single.just((Object)CollectionsKt.first(it)) : new FileRemoteDataStore().getFile(this.$fileId).flatMap(new Function(this.$fileId){
                    final /* synthetic */ String $fileId;
                    {
                        this.$fileId = $fileId;
                    }

                    @NotNull
                    public final SingleSource<? extends EkoFileEntity> apply(@NotNull EkoFileDto dto) {
                        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
                        return (SingleSource)new FileLocalDataStore().saveFiles(new FileEntityMapper().map(CollectionsKt.listOf((Object)dto))).andThen((SingleSource)Single.defer(() -> getRawFile.1.apply$lambda$0(this.$fileId)).map((Function)getRawFile.2.INSTANCE));
                    }

                    private static final SingleSource apply$lambda$0(String $fileId) {
                        Intrinsics.checkNotNullParameter((Object)$fileId, (String)"$fileId");
                        return (SingleSource)new FileLocalDataStore().getRawFile($fileId);
                    }
                }));
            }
        }).map((Function)getRawFile.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"fileId: String): Single<\u2026r().map(it)\n            }");
        return single;
    }

    private final AmityRawFile getLocalRawFile(String fileId) {
        Ref.ObjectRef rawFile = new Ref.ObjectRef();
        Completable.fromCallable(() -> FileRepository.getLocalRawFile$lambda$0(fileId, rawFile)).subscribeOn(Schedulers.io()).blockingAwait();
        return (AmityRawFile)rawFile.element;
    }

    private final AmityRawFile getLocalRawFileNow(String fileId) {
        AmityRawFile rawFile = null;
        EkoFileEntity entity = new FileLocalDataStore().getFile(fileId);
        if (entity != null) {
            rawFile = new RawFileModelMapper().map(entity);
        }
        return rawFile;
    }

    @NotNull
    public final Completable createLocalFile(@NotNull String fileId, @NotNull String fileType, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return new FileLocalDataStore().createLocalFile(fileId, fileType, filePath);
    }

    @Nullable
    public final AmityImage getImage(@NotNull String fileId) {
        AmityImage amityImage;
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        AmityRawFile amityRawFile = this.getLocalRawFile(fileId);
        if (amityRawFile != null) {
            AmityRawFile it = amityRawFile;
            boolean bl = false;
            amityImage = new AmityImage(it);
        } else {
            amityImage = null;
        }
        return amityImage;
    }

    @Nullable
    public final AmityImage getImageNow(@NotNull String fileId) {
        AmityImage amityImage;
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        AmityRawFile amityRawFile = this.getLocalRawFileNow(fileId);
        if (amityRawFile != null) {
            AmityRawFile it = amityRawFile;
            boolean bl = false;
            amityImage = new AmityImage(it);
        } else {
            amityImage = null;
        }
        return amityImage;
    }

    @Nullable
    public final AmityFile getFile(@NotNull String fileId) {
        AmityFile amityFile;
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        AmityRawFile amityRawFile = this.getLocalRawFile(fileId);
        if (amityRawFile != null) {
            AmityRawFile it = amityRawFile;
            boolean bl = false;
            amityFile = new AmityFile(it);
        } else {
            amityFile = null;
        }
        return amityFile;
    }

    @Nullable
    public final AmityAudio getAudio(@NotNull String fileId) {
        AmityAudio amityAudio;
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        AmityRawFile amityRawFile = this.getLocalRawFile(fileId);
        if (amityRawFile != null) {
            AmityRawFile it = amityRawFile;
            boolean bl = false;
            amityAudio = new AmityAudio(it);
        } else {
            amityAudio = null;
        }
        return amityAudio;
    }

    @Nullable
    public final AmityVideo getVideo(@NotNull String fileId) {
        AmityVideo amityVideo;
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        AmityRawFile amityRawFile = this.getLocalRawFile(fileId);
        if (amityRawFile != null) {
            AmityRawFile it = amityRawFile;
            boolean bl = false;
            amityVideo = new AmityVideo(it);
        } else {
            amityVideo = null;
        }
        return amityVideo;
    }

    @NotNull
    public final Flowable<AmityUploadResult<AmityImage>> uploadImage(@NotNull String uploadId, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return new AmityImageUploadService.Builder().fileUri$amity_sdk_release(uri).isFullImage(true).uploadId(uploadId).build().transfer();
    }

    @NotNull
    public final Flowable<AmityUploadResult<AmityFile>> uploadFile(@NotNull String uploadId, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return new AmityFileUploadService.Builder().fileUri$amity_sdk_release(uri).uploadId(uploadId).build().transfer();
    }

    @NotNull
    public final Flowable<AmityUploadResult<AmityAudio>> uploadAudio(@NotNull String uploadId, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return new AmityAudioUploadService.Builder().fileUri$amity_sdk_release(uri).uploadId(uploadId).build().transfer();
    }

    @NotNull
    public final Flowable<AmityUploadResult<AmityVideo>> uploadVideo(@NotNull String uploadId, @NotNull Uri uri, @NotNull AmityContentFeedType feedType) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)((Object)feedType), (String)"feedType");
        return new AmityVideoUploadService.Builder().fileUri$amity_sdk_release(uri).feedType$amity_sdk_release(feedType).uploadId(uploadId).build().transfer();
    }

    public final void cancelUpload(@NotNull String uploadId) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        RxUploadService.Companion.cancel(uploadId);
    }

    @NotNull
    public final Flowable<AmityUploadInfo> getUploadInfo(@NotNull String uploadId) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        Flowable flowable = RxUploadService.Companion.properties(uploadId).map((Function)getUploadInfo.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"RxUploadService.properti\u2026p { AmityUploadInfo(it) }");
        return flowable;
    }

    @NotNull
    public final Completable deleteFile(@NotNull String fileId) {
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Completable completable = new FileRemoteDataStore().deleteFile(fileId).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"FileRemoteDataStore().de\u2026         .ignoreElement()");
        return completable;
    }

    private static final Unit getLocalRawFile$lambda$0(String $fileId, Ref.ObjectRef $rawFile) {
        Intrinsics.checkNotNullParameter((Object)$fileId, (String)"$fileId");
        Intrinsics.checkNotNullParameter((Object)$rawFile, (String)"$rawFile");
        EkoFileEntity entity = new FileLocalDataStore().getFile($fileId);
        if (entity != null) {
            $rawFile.element = new RawFileModelMapper().map(entity);
        }
        return Unit.INSTANCE;
    }
}

