package com.amity.socialcloud.sdk.social.data.story

import com.amity.socialcloud.sdk.common.EntityMapper
import com.amity.socialcloud.sdk.dto.social.story.StoryDto
import com.amity.socialcloud.sdk.entity.social.story.StoryEntity
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionMap


internal class StoryEntityMapper : EntityMapper<StoryDto, StoryEntity>() {

    override fun map(list: List<StoryDto>): List<StoryEntity> {
        return list.map {
            map(it)
        }
    }

    private fun map(dto: StoryDto) : StoryEntity {
        return StoryEntity().apply {
            storyId = dto.storyId ?: ""
            uniqueId = dto.referenceId ?: dto.storyId ?: ""
            targetType = dto.targetType ?: ""
            targetId = dto.targetPublicId ?: ""
            creatorId = dto.creatorPublicId ?: ""
            dataType = dto.dataType ?: ""
            data = dto.data
            metadata = dto.metadata
            items = dto.items
            reactions = dto.reactions ?: AmityReactionMap()
            reactionCount = dto.reactionsCount ?: 0
            commentCount = dto.commentsCount ?: 0
            flagCount = dto.flagCount?: 0
            impression = dto.impression ?: 0
            reach = dto.reach ?: 0
            isDeleted = dto.isDeleted ?: false
            storyExpiresAt = dto.expiresAt
            createdAt = dto.createdAt
            updatedAt = dto.updatedAt
            path = dto.path ?: path
        }

    }

}
