package com.amity.socialcloud.sdk.core.data.analytics.paging

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.entity.core.user.UserEntity
import com.amity.socialcloud.sdk.model.core.analytics.AmityViewedType
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagingDao

@Dao
internal interface ViewedUsersPagingDao : DynamicQueryStreamPagingDao<UserEntity> {

    @RawQuery(observedEntities = [UserEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, UserEntity>

    fun getViewedUsersPagingSource(
        viewableItemType: AmityViewedType,
        viewableItemId: String
    ): PagingSource<Int, UserEntity> {
        val order = AmityPagingDao.Order.ASC
        return queryPagingData(
            generateQueryStreamSQL(
                tableName = "user",
                primaryKeyColumnName = "userId",
                nonce = AmityNonce.ANALYTICS_VIEWED_USERS,
                order = order,
                dynamicQueryStreamKeyCreator = ViewedUsersKeyCreator(
                    viewableItemType = viewableItemType,
                    viewableItemId = viewableItemId
                )
            )
        )
    }
}