package com.amity.socialcloud.sdk.api.social.comment.create

import com.amity.socialcloud.sdk.model.social.comment.AmityCommentReferenceType

class AmityCommentCreationTarget internal constructor(private val commentId: String? = null) {

    class Builder internal constructor(private val referenceType: String,
                                       private val referenceId: String,
                                       private val commentId: String? = null) {

        private var parentId: String? = null

        /**
         * @param [parentId] a commentId of the comment to reply to.
         * When creating a root level comment, [parentId] must be null.
         * The default value of [parentId] is null.
         * @return new instance of AmityCommentCreationTarget.Builder
         */
        fun parentId(parentId: String?): Builder {
            return apply { this.parentId = parentId }
        }

        /**
         * Instantiates AmityCommentCreationType with the built target
         * @return new instance of AmityCommentCreationType
         */
        fun with(): AmityCommentCreationType {
            return AmityCommentCreationType(referenceType, referenceId, parentId, commentId)
        }
    }

    /**
     * @param [postId] a postId to comment on
     * @return new instance of AmityCommentCreationTarget.Builder
     */
    fun post(postId: String): Builder {
        return Builder(AmityCommentReferenceType.POST.value, postId, commentId)
    }

    /**
     * @param [storyId] a storyId to comment on
     * @return new instance of AmityCommentCreationTarget.Builder
     */
    fun story(storyId: String): Builder {
        return Builder(AmityCommentReferenceType.STORY.value, storyId, commentId)
    }


    /**
     * @param [contentId] a contentId to comment on
     * @return new instance of AmityCommentCreationTarget.Builder
     */
    fun content(contentId: String): Builder {
        return Builder(AmityCommentReferenceType.CONTENT.value, contentId, commentId)
    }

}